

<?php $__env->startSection('content'); ?>
<div class="bg-white rounded-xl shadow p-6">
    <h2 class="text-2xl font-bold mb-4">Buat Transaksi Baru</h2>

    <form action="<?php echo e(route('karyawan.transaksi.store')); ?>" method="POST">
        <?php echo csrf_field(); ?>

        <div class="mb-4">
            <label class="block text-sm font-medium mb-1">Tanggal Transaksi</label>
            <input type="datetime-local" name="tanggal_transaksi" value="<?php echo e(now()->format('Y-m-d\TH:i')); ?>" 
                class="border rounded-lg w-full p-2" required>
        </div>

        <div class="mb-4">
            <label class="block text-sm font-medium mb-1">Pilih Obat</label>
            <select name="items[0][obat_id]" class="border rounded-lg w-full p-2" required>
                <?php $__currentLoopData = $obats; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $obat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($obat->id); ?>">
                        <?php echo e($obat->masterObat->nama); ?> - Rp<?php echo e(number_format($obat->harga_jual, 0, ',', '.')); ?> - Sisa: <?php echo e($obat->jumlah); ?>

                    </option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>

        <div class="mb-4">
            <label class="block text-sm font-medium mb-1">Jumlah</label>
            <input type="number" name="items[0][jumlah]" class="border rounded-lg w-full p-2" min="1" required>
        </div>

        <button type="submit" class="bg-blue-600 text-white px-4 py-2 rounded-lg hover:bg-blue-700">
            Simpan Transaksi
        </button>
    </form>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('karyawan.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\inventory-apotik\resources\views/karyawan/transaksi/create.blade.php ENDPATH**/ ?>