

<?php $__env->startSection('content'); ?>
<div class="p-6">
    <!-- Header -->
    <div class="flex flex-col md:flex-row md:items-center md:justify-between mb-6">
        <div>
            <h1 class="text-2xl font-bold text-gray-900 flex items-center">
                <i class="fas fa-tags text-blue-500 mr-3"></i>Daftar Kategori Obat
            </h1>
            <p class="text-gray-600 mt-2">Kelola kategori obat dalam sistem inventory apotik</p>
        </div>
        <div class="mt-4 md:mt-0">
            <a href="<?php echo e(route('admin.kategoris.create')); ?>" class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2.5 rounded-lg flex items-center transition shadow-md hover:shadow-lg">
                <i class="fas fa-plus-circle mr-2"></i> Tambah Kategori
            </a>
        </div>
    </div>

    <!-- Alert Success -->
    <?php if(session('success')): ?>
        <div class="bg-green-100 border-l-4 border-green-500 text-green-700 p-4 rounded mb-6 flex items-start">
            <i class="fas fa-check-circle text-green-500 mt-1 mr-3"></i>
            <div>
                <p class="font-medium">Berhasil!</p>
                <p><?php echo e(session('success')); ?></p>
            </div>
        </div>
    <?php endif; ?>

    <!-- Table -->
    <div class="bg-white rounded-xl shadow overflow-hidden">
        <div class="overflow-x-auto">
            <table class="min-w-full text-sm">
                <thead class="bg-gray-50 text-gray-700">
                    <tr>
                        <th class="px-6 py-4 text-left font-medium">No</th>
                        <th class="px-6 py-4 text-left font-medium">Nama Kategori</th>
                        <th class="px-6 py-4 text-left font-medium">Aksi</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-100">
                    <?php $__currentLoopData = $kategoris; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $kategori): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr class="hover:bg-gray-50 transition">
                            <td class="px-6 py-4"><?php echo e($loop->iteration); ?></td>
                            <td class="px-6 py-4">
                                <div class="flex items-center">
                                    <div class="bg-blue-100 text-blue-800 p-2 rounded-lg mr-3">
                                        <i class="fas fa-tag"></i>
                                    </div>
                                    <span class="font-medium"><?php echo e($kategori->nama); ?></span>
                                </div>
                            </td>
                            <td class="px-6 py-4">
                                <div class="flex items-center space-x-3">
                                    <a href="<?php echo e(route('admin.kategoris.edit', $kategori->id)); ?>" class="text-blue-600 hover:text-blue-800 transition flex items-center" title="Edit">
                                        <i class="fas fa-edit mr-1"></i> Edit
                                    </a>
                                    <span class="text-gray-300">|</span>
                                    <form action="<?php echo e(route('admin.kategoris.destroy', $kategori->id)); ?>" method="POST" class="inline-block" onsubmit="return confirm('Apakah Anda yakin ingin menghapus kategori ini?')">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button class="text-red-600 hover:text-red-800 transition flex items-center" type="submit" title="Hapus">
                                            <i class="fas fa-trash-alt mr-1"></i> Hapus
                                        </button>
                                    </form>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    <?php if($kategoris->isEmpty()): ?>
                        <tr>
                            <td colspan="3" class="px-6 py-8 text-center">
                                <div class="flex flex-col items-center justify-center text-gray-400">
                                    <i class="fas fa-inbox text-4xl mb-3"></i>
                                    <p>Belum ada kategori obat.</p>
                                    <p class="text-sm mt-2">Klik "Tambah Kategori" untuk menambahkan kategori baru.</p>
                                </div>
                            </td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
        
        <!-- Pagination - Hanya tampilkan jika menggunakan paginate() -->
        <?php if(method_exists($kategoris, 'hasPages') && $kategoris->hasPages()): ?>
        <div class="bg-white px-6 py-4 border-t border-gray-100">
            <?php echo e($kategoris->links()); ?>

        </div>
        <?php endif; ?>
    </div>
</div>

<style>
    /* Style untuk pagination jika digunakan */
    .pagination {
        display: flex;
        justify-content: center;
        list-style-type: none;
        padding: 0;
    }
    
    .pagination li {
        margin: 0 4px;
    }
    
    .pagination li a,
    .pagination li span {
        display: inline-block;
        padding: 8px 12px;
        border-radius: 6px;
        border: 1px solid #e5e7eb;
        color: #4b5563;
        text-decoration: none;
        transition: all 0.2s;
    }
    
    .pagination li a:hover {
        background-color: #f3f4f6;
    }
    
    .pagination li.active span {
        background-color: #3b82f6;
        color: white;
        border-color: #3b82f6;
    }
    
    .pagination li.disabled span {
        color: #9ca3af;
        cursor: not-allowed;
    }
</style>

<!-- Include Font Awesome -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\inventory-apotik\resources\views/admin/kategori/index.blade.php ENDPATH**/ ?>