<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard Dokter - Sistem Apotik</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://unpkg.com/lucide@latest/dist/umd/lucide.min.js"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap');
        
        :root {
            --primary: #4f46e5;
            --primary-light: #6366f1;
            --primary-dark: #4338ca;
            --secondary: #10b981;
            --accent: #f59e0b;
        }
        
        body {
            font-family: 'Poppins', sans-serif;
            background-color: #f8fafc;
        }
        
        .sidebar {
            background: linear-gradient(to bottom, var(--primary), var(--primary-dark));
            box-shadow: 0 0 20px rgba(0, 0, 0, 0.1);
            transition: all 0.3s ease;
        }
        
        .nav-item {
            transition: all 0.2s ease;
            border-radius: 8px;
        }
        
        .nav-item:hover {
            background-color: rgba(255, 255, 255, 0.1);
            transform: translateX(5px);
        }
        
        .nav-item.active {
            background-color: rgba(255, 255, 255, 0.15);
            font-weight: 500;
        }
        
        .main-content {
            transition: margin-left 0.3s ease;
        }
        
        .top-navbar {
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
            backdrop-filter: blur(10px);
        }
        
        @media (max-width: 768px) {
            .sidebar {
                transform: translateX(-100%);
                z-index: 50;
            }
            
            .sidebar.open {
                transform: translateX(0);
            }
            
            .main-content {
                margin-left: 0 !important;
            }
            
            .overlay {
                display: none;
                position: fixed;
                top: 0;
                left: 0;
                right: 0;
                bottom: 0;
                background-color: rgba(0, 0, 0, 0.5);
                z-index: 40;
            }
            
            .overlay.open {
                display: block;
            }
        }
    </style>
</head>
<body class="flex">
    <!-- Mobile menu button -->
    <div class="md:hidden fixed top-4 left-4 z-50">
        <button id="menuToggle" class="p-2 rounded-md bg-indigo-600 text-white shadow-lg">
            <i data-lucide="menu" class="w-5 h-5"></i>
        </button>
    </div>

    <!-- Overlay for mobile -->
    <div id="overlay" class="overlay" onclick="closeSidebar()"></div>

    <!-- Sidebar -->
    <aside id="sidebar" class="sidebar w-64 h-screen text-white fixed flex flex-col justify-between">
        <div class="p-6">
            <!-- Logo -->
            <div class="flex items-center gap-3 mb-8 pt-4">
                <div class="bg-white p-2 rounded-xl">
                    <i class="fas fa-pills text-indigo-600 text-xl"></i>
                </div>
                <h1 class="text-xl font-bold">Apotik Sehat</h1>
            </div>

            <!-- Navigation -->
            <nav class="space-y-2">
                <a href="<?php echo e(route('dokter.dashboard')); ?>" class="nav-item flex items-center gap-3 py-3 px-4 rounded-lg <?php echo e(request()->routeIs('dokter.dashboard') ? 'active' : ''); ?>">
                    <i data-lucide="layout-dashboard" class="w-5 h-5"></i>
                    <span>Dashboard</span>
                </a>

                <a href="<?php echo e(route('dokter.reseps.index')); ?>" class="nav-item flex items-center gap-3 py-3 px-4 rounded-lg <?php echo e(request()->routeIs('dokter.reseps.*') ? 'active' : ''); ?>">
                    <i data-lucide="file-text" class="w-5 h-5"></i>
                    <span>Resep Obat</span>
                </a>

                <a href="<?php echo e(route('dokter.rekammedik.create')); ?>" class="nav-item flex items-center gap-3 py-3 px-4 rounded-lg <?php echo e(request()->routeIs('dokter.rekammediks.*') ? 'active' : ''); ?>">
                    <i data-lucide="clipboard-list" class="w-5 h-5"></i>
                    <span>Rekam Medik</span>
                </a>

                <a href="<?php echo e(route('dokter.rekammedik.index')); ?>" class="nav-item flex items-center gap-3 py-3 px-4 rounded-lg <?php echo e(request()->routeIs('dokter.rekammediks.*') ? 'active' : ''); ?>">
                    <i data-lucide="history" class="w-5 h-5"></i>
                    <span>Riwayat Medik</span>
                </a>
            </nav>
        </div>

        <!-- Logout Button -->
        <div class="p-6 border-t border-indigo-400">
            <button onclick="openLogoutModal()" class="nav-item flex items-center gap-3 py-3 px-4 rounded-lg hover:bg-red-500 w-full text-left">
                <i data-lucide="log-out" class="w-5 h-5"></i>
                <span>Logout</span>
            </button>
        </div>
    </aside>

    <!-- Main Content -->
    <div class="main-content md:ml-64 flex-1 min-h-screen flex flex-col">
        <!-- Top Navigation -->
        <header class="top-navbar bg-white px-6 py-4 flex justify-between items-center sticky top-0 z-30">
            <h2 class="text-xl font-semibold text-gray-800">
                <span id="pageTitle">Dashboard Dokter</span>
            </h2>
            <div class="flex items-center gap-4">
                <div class="hidden md:flex items-center gap-2 text-sm text-gray-600">
                    <i data-lucide="calendar" class="w-4 h-4"></i>
                    <span id="currentDate"></span>
                </div>
                <div class="flex items-center gap-3 bg-gray-100 rounded-full py-1 px-3">
                    <div class="bg-indigo-100 p-1 rounded-full">
                        <i data-lucide="user" class="w-4 h-4 text-indigo-600"></i>
                    </div>
                    <span class="text-gray-800 font-medium text-sm">
                        <?php echo e(Auth::user()->name); ?>

                    </span>
                </div>
            </div>
        </header>

        <!-- Main Content -->
        <main class="p-6 flex-1">
            <?php echo $__env->yieldContent('content'); ?>
        </main>

        <!-- Footer -->
        <footer class="bg-white border-t py-4 px-6 text-center">
            <p class="text-gray-600 text-sm">© <?php echo e(date('Y')); ?> Sistem Apotik. All rights reserved.</p>
        </footer>
    </div>

    <!-- Logout Modal -->
    <div id="logoutModal" class="fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center z-50 hidden p-4">
        <div class="bg-white rounded-xl shadow-2xl p-6 w-full max-w-md">
            <div class="flex items-center gap-3 mb-4">
                <div class="bg-red-100 p-2 rounded-full">
                    <i data-lucide="log-out" class="w-6 h-6 text-red-600"></i>
                </div>
                <h2 class="text-xl font-semibold text-gray-800">Konfirmasi Logout</h2>
            </div>
            <p class="text-gray-600 mb-2">Apakah Anda yakin ingin keluar dari sistem?</p>
            <p class="text-sm text-gray-500">Sesi Anda akan berakhir dan Anda perlu login kembali untuk mengakses sistem.</p>
            <div class="flex justify-end gap-3 mt-6">
                <button onclick="closeLogoutModal()" class="px-4 py-2.5 border border-gray-300 text-gray-700 rounded-lg hover:bg-gray-50 transition flex items-center">
                    <i data-lucide="x" class="w-4 h-4 mr-2"></i> Batal
                </button>
                <form method="POST" action="<?php echo e(route('logout')); ?>">
                    <?php echo csrf_field(); ?>
                    <button type="submit" class="px-4 py-2.5 bg-red-600 text-white rounded-lg hover:bg-red-700 transition flex items-center">
                        <i data-lucide="log-out" class="w-4 h-4 mr-2"></i> Logout
                    </button>
                </form>
            </div>
        </div>
    </div>

    <script>
        // Initialize Lucide icons
        lucide.createIcons();
        
        // Set current date
        function setCurrentDate() {
            const now = new Date();
            const options = { weekday: 'long', year: 'numeric', month: 'long', day: 'numeric' };
            document.getElementById('currentDate').textContent = now.toLocaleDateString('id-ID', options);
        }
        
        // Mobile sidebar toggle
        function toggleSidebar() {
            document.getElementById('sidebar').classList.toggle('open');
            document.getElementById('overlay').classList.toggle('open');
        }
        
        function closeSidebar() {
            document.getElementById('sidebar').classList.remove('open');
            document.getElementById('overlay').classList.remove('open');
        }
        
        // Logout modal functions
        function openLogoutModal() {
            document.getElementById('logoutModal').classList.remove('hidden');
        }
        
        function closeLogoutModal() {
            document.getElementById('logoutModal').classList.add('hidden');
        }
        
        // Set active page title
        function setPageTitle() {
            const activeLink = document.querySelector('.nav-item.active');
            if (activeLink) {
                const pageTitle = activeLink.querySelector('span').textContent;
                document.getElementById('pageTitle').textContent = pageTitle;
            }
        }
        
        // Initialize on page load
        document.addEventListener('DOMContentLoaded', function() {
            setCurrentDate();
            setPageTitle();
            
            // Add event listener for menu toggle on mobile
            document.getElementById('menuToggle').addEventListener('click', toggleSidebar);
            
            // Close sidebar when clicking outside on mobile
            document.getElementById('overlay').addEventListener('click', closeSidebar);
            
            // Close sidebar when resizing to desktop
            window.addEventListener('resize', function() {
                if (window.innerWidth >= 768) {
                    closeSidebar();
                }
            });
        });
    </script>

    <?php echo $__env->yieldContent('modal'); ?>
    <?php echo $__env->yieldContent('scripts'); ?>
</body>
</html><?php /**PATH D:\inventory-apotik\resources\views/dokter/layout.blade.php ENDPATH**/ ?>