

<?php $__env->startSection('content'); ?>
<div class="max-w-6xl mx-auto bg-white rounded-2xl shadow-lg p-8">
    <!-- Header -->
    <div class="flex items-center gap-3 mb-8 pb-4 border-b border-gray-100">
        <div class="bg-blue-100 p-3 rounded-xl">
            <svg class="w-8 h-8 text-blue-600" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z" />
            </svg>
        </div>
        <div>
            <h2 class="text-2xl font-bold text-gray-800">Tambah Pembelian Obat</h2>
            <p class="text-gray-600 mt-1">Tambah data pembelian obat baru ke dalam sistem</p>
        </div>
    </div>

    <form id="pembelianForm" action="<?php echo e(route('admin.pembelian.store')); ?>" method="POST" class="space-y-8">
        <?php echo csrf_field(); ?>

        <!-- Informasi Utama -->
        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
            
            <div class="space-y-2">
                <label class="block text-gray-700 font-medium mb-2 flex items-center">
                    <i class="fas fa-truck mr-2 text-blue-500"></i>Supplier
                </label>
                <select name="supplier_id" class="w-full border-gray-300 rounded-xl shadow-sm focus:ring-2 focus:ring-blue-500 focus:border-blue-500 py-3 px-4" required>
                    <option value="">-- Pilih Supplier --</option>
                    <?php $__currentLoopData = $suppliers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $supplier): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($supplier->id); ?>"><?php echo e($supplier->nama); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>

            
            <div class="space-y-2">
                <label class="block text-gray-700 font-medium mb-2 flex items-center">
                    <i class="far fa-calendar-alt mr-2 text-blue-500"></i>Tanggal Pembelian
                </label>
                <input type="date" name="tanggal_pembelian" value="<?php echo e(date('Y-m-d')); ?>"
                       class="w-full border-gray-300 rounded-xl shadow-sm focus:ring-2 focus:ring-blue-500 focus:border-blue-500 py-3 px-4" required>
            </div>
        </div>

        
        <div class="pt-4">
            <div class="flex items-center justify-between mb-4">
                <label class="block text-gray-700 font-medium flex items-center">
                    <i class="fas fa-pills mr-2 text-blue-500"></i>Daftar Obat
                </label>
                <button type="button" id="add-obat" class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded-xl shadow-md flex items-center transition">
                    <i class="fas fa-plus-circle mr-2"></i> Tambah Obat
                </button>
            </div>
            
            <div id="obat-container" class="space-y-4">
                <div class="grid grid-cols-1 md:grid-cols-12 gap-4 items-center bg-blue-50 p-5 rounded-xl border border-blue-100 obat-item">
                    <div class="md:col-span-2">
                        <label class="block text-xs text-gray-500 mb-1">Nama Obat</label>
                        <select name="obat[0][master_obat_id]" class="w-full border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 py-2 px-3" required>
                            <option value="">-- Pilih Obat --</option>
                            <?php $__currentLoopData = $masterObats; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $obat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($obat->id); ?>"><?php echo e($obat->nama); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="md:col-span-2">
                        <label class="block text-xs text-gray-500 mb-1">Kode Barcode</label>
                        <input type="text" name="obat[0][kode_barcode]" placeholder="Kode Barcode" class="w-full border-gray-300 rounded-lg py-2 px-3">
                    </div>
                    <div class="md:col-span-1">
                        <label class="block text-xs text-gray-500 mb-1">Jumlah</label>
                        <input type="number" name="obat[0][jumlah]" placeholder="Jumlah" class="w-full border-gray-300 rounded-lg py-2 px-3 jumlah" required min="1">
                    </div>
                    <div class="md:col-span-1">
                        <label class="block text-xs text-gray-500 mb-1">Satuan</label>
                        <input type="text" name="obat[0][satuan]" placeholder="Satuan" class="w-full border-gray-300 rounded-lg py-2 px-3" required>
                    </div>
                    <div class="md:col-span-2">
                        <label class="block text-xs text-gray-500 mb-1">Harga Beli</label>
                        <input type="number" name="obat[0][harga_beli]" placeholder="Harga Beli" class="w-full border-gray-300 rounded-lg py-2 px-3 harga-beli" required min="0">
                    </div>
                    <div class="md:col-span-2">
                        <label class="block text-xs text-gray-500 mb-1">Harga Jual</label>
                        <input type="number" name="obat[0][harga_jual]" placeholder="Harga Jual" class="w-full border-gray-300 rounded-lg py-2 px-3" required min="0">
                    </div>
                    <div class="md:col-span-2">
                        <label class="block text-xs text-gray-500 mb-1">Tanggal Kadaluarsa</label>
                        <input type="date" name="obat[0][expired_at]" class="w-full border-gray-300 rounded-lg py-2 px-3">
                    </div>
                    <div class="md:col-span-1 flex justify-center pt-5">
                        <button type="button" class="remove-obat bg-red-500 hover:bg-red-600 text-white p-2 rounded-lg flex items-center justify-center">
                            <i class="fas fa-trash"></i>
                        </button>
                    </div>
                </div>
            </div>
        </div>

        
        <div class="text-right bg-blue-50 p-6 rounded-xl border border-blue-100">
            <h3 class="text-xl font-bold text-gray-800 flex items-center justify-end">
                <i class="fas fa-receipt mr-2 text-blue-600"></i> Total Pembayaran:
            </h3>
            <p class="text-3xl font-extrabold text-green-600 mt-2" id="total-pembayaran">Rp 0</p>
            <input type="hidden" name="total_pembayaran" id="total-pembayaran-input">
        </div>

        
        <div class="flex justify-end gap-4 pt-4">
            <a href="<?php echo e(route('admin.pembelian.index')); ?>" class="bg-gray-500 hover:bg-gray-600 text-white px-6 py-3 rounded-xl shadow-md flex items-center transition">
                <i class="fas fa-times-circle mr-2"></i> Batal
            </a>
            <button type="button" id="btn-simpan" class="bg-green-600 hover:bg-green-700 text-white px-6 py-3 rounded-xl shadow-md flex items-center transition">
                <i class="fas fa-save mr-2"></i> Simpan Pembelian
            </button>
        </div>
    </form>
</div>


<div id="modal-konfirmasi" class="fixed inset-0 bg-black bg-opacity-50 hidden justify-center items-center z-50 p-4">
    <div class="bg-white rounded-xl shadow-2xl p-6 w-full max-w-md">
        <div class="flex items-center gap-3 mb-4">
            <div class="bg-blue-100 p-2 rounded-full">
                <i class="fas fa-question-circle text-blue-600 text-xl"></i>
            </div>
            <h2 class="text-xl font-bold text-gray-800">Konfirmasi Simpan</h2>
        </div>
        <p class="text-gray-600 mb-2">Apakah Anda yakin ingin menyimpan data pembelian ini?</p>
        <p class="text-sm text-gray-500">Total pembayaran: <span id="konfirmasi-total" class="font-semibold">Rp 0</span></p>
        <div class="flex justify-end gap-3 mt-6">
            <button type="button" id="batal-konfirmasi" class="bg-gray-500 hover:bg-gray-600 text-white px-4 py-2.5 rounded-lg flex items-center transition">
                <i class="fas fa-times mr-2"></i> Batal
            </button>
            <button type="button" id="konfirmasi-simpan" class="bg-green-600 hover:bg-green-700 text-white px-4 py-2.5 rounded-lg flex items-center transition">
                <i class="fas fa-check mr-2"></i> Ya, Simpan
            </button>
        </div>
    </div>
</div>

<script>
    let index = 1;

    document.getElementById('add-obat').addEventListener('click', () => {
        const container = document.getElementById('obat-container');
        const item = document.querySelector('.obat-item').cloneNode(true);

        item.querySelectorAll('input, select').forEach(input => {
            input.value = '';
            input.name = input.name.replace(/\d+/, index);
        });

        item.querySelector('.remove-obat').classList.remove('hidden');
        container.appendChild(item);
        index++;
        
        // Add event listeners to new inputs
        item.querySelector('.jumlah').addEventListener('input', hitungTotal);
        item.querySelector('.harga-beli').addEventListener('input', hitungTotal);
        
        // Add remove functionality
        item.querySelector('.remove-obat').addEventListener('click', function() {
            this.closest('.obat-item').remove();
            renumberItems();
            hitungTotal();
        });
    });

    function renumberItems() {
        const items = document.querySelectorAll('.obat-item');
        items.forEach((item, idx) => {
            item.querySelectorAll('input, select').forEach(input => {
                if (input.name) {
                    input.name = input.name.replace(/\d+/, idx);
                }
            });
        });
        index = items.length;
    }

    function hitungTotal() {
        let total = 0;
        document.querySelectorAll('.obat-item').forEach(item => {
            const jumlah = parseFloat(item.querySelector('.jumlah').value) || 0;
            const hargaBeli = parseFloat(item.querySelector('.harga-beli').value) || 0;
            total += jumlah * hargaBeli;
        });
        
        const formattedTotal = 'Rp ' + total.toLocaleString('id-ID');
        document.getElementById('total-pembayaran').textContent = formattedTotal;
        document.getElementById('total-pembayaran-input').value = total;
        document.getElementById('konfirmasi-total').textContent = formattedTotal;
    }

    document.getElementById('btn-simpan').addEventListener('click', () => {
        hitungTotal(); // Update total sebelum menampilkan modal
        document.getElementById('modal-konfirmasi').classList.remove('hidden');
    });

    document.getElementById('batal-konfirmasi').addEventListener('click', () => {
        document.getElementById('modal-konfirmasi').classList.add('hidden');
    });

    document.getElementById('konfirmasi-simpan').addEventListener('click', () => {
        document.getElementById('pembelianForm').submit();
    });

    // Initialize event listeners for initial items
    document.querySelectorAll('.jumlah, .harga-beli').forEach(input => {
        input.addEventListener('input', hitungTotal);
    });

    document.querySelectorAll('.remove-obat').forEach(button => {
        button.addEventListener('click', function() {
            this.closest('.obat-item').remove();
            renumberItems();
            hitungTotal();
        });
    });

    // Initial calculation
    hitungTotal();
</script>

<!-- Include Font Awesome -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

<style>
    .obat-item {
        transition: all 0.3s ease;
    }
    
    .obat-item:hover {
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.05);
    }
    
    input, select {
        transition: all 0.2s;
    }
    
    input:focus, select:focus {
        box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.2);
    }
    
    .remove-obat {
        transition: all 0.2s;
    }
</style>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\inventory-apotik\resources\views/admin/pembelian/create.blade.php ENDPATH**/ ?>