

<?php $__env->startSection('content'); ?>
<div class="bg-white rounded-xl shadow p-6">
    <h2 class="text-2xl font-bold mb-4">Detail Resep Dokter</h2>

    <div class="mb-4">
        <p><strong>Pasien:</strong> <?php echo e($rekamMedik->nama_pasien); ?></p>
        <p><strong>Dokter:</strong> <?php echo e($rekamMedik->dokter->name); ?></p>
        <p><strong>Tanggal:</strong> <?php echo e($rekamMedik->created_at->format('d/m/Y H:i')); ?></p>
    </div>

    <h3 class="text-lg font-semibold mb-2">Daftar Obat</h3>
    <table class="min-w-full divide-y divide-gray-200 text-sm mb-4">
        <thead class="bg-gray-50">
            <tr>
                <th class="px-4 py-2 text-left font-medium">Nama Obat</th>
                <th class="px-4 py-2 text-left font-medium">Dosis</th>
                <th class="px-4 py-2 text-left font-medium">Aturan Pakai</th>
                <th class="px-4 py-2 text-left font-medium">Jumlah</th>
            </tr>
        </thead>
        <tbody class="divide-y divide-gray-100">
            <?php $__currentLoopData = $rekamMedik->resep->obats; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $obat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td class="px-4 py-2"><?php echo e($obat->nama); ?></td>
                    <td class="px-4 py-2"><?php echo e($obat->pivot->dosis); ?></td>
                    <td class="px-4 py-2"><?php echo e($obat->pivot->aturan_pakai); ?></td>
                    <td class="px-4 py-2"><?php echo e($obat->pivot->jumlah); ?></td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>

    <form action="<?php echo e(route('karyawan.transaksi.rekam_medik.store', $rekamMedik->id)); ?>" method="POST">
        <?php echo csrf_field(); ?>
        <button type="submit"
            class="bg-green-600 text-white px-4 py-2 rounded-lg hover:bg-green-700">
            Tebus Obat
        </button>
    </form>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('karyawan.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\inventory-apotik\resources\views/karyawan/transaksi/rekam_medik_show.blade.php ENDPATH**/ ?>