<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AdminController;
use App\Http\Controllers\AdminLaporanController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\UserManagementController;
use App\Http\Controllers\ObatController;
use App\Http\Controllers\KategoriController;
use App\Http\Controllers\SupplierController;
use App\Http\Controllers\KaryawanController;
use App\Http\Controllers\AjaxObatController;
use App\Http\Controllers\PembelianController;
use App\Http\Controllers\MasterObatController;

// Controller untuk dokter 
use App\Http\Controllers\DokterController;
use App\Http\Controllers\ResepController;
use App\Http\Controllers\RekamMedikController;
use App\Http\Controllers\ResepObatController;

use App\Http\Controllers\TransaksiController;
use App\Http\Controllers\TransaksiKaryawanController;
use App\Http\Controllers\KaryawanObatController;
use App\Models\Resep;

// Redirect root ke login
Route::get('/', fn () => redirect('/login'));

// Login routes
Route::get('/login', [UserController::class, 'login'])->name('login');
Route::post('/login', [UserController::class, 'auth'])->name('auth');
Route::post('/logout', [UserController::class, 'logout'])->name('logout');
Route::get('/ajax/obats/search', [AjaxObatController::class, 'search'])->name('ajax.obats.search');


// ===================== ADMIN ROUTES =====================
Route::middleware(['auth', 'role:admin'])->prefix('admin')->name('admin.')->group(function () {
    Route::get('/dashboard', [AdminController::class, 'dashboard'])->name('dashboard');
    
    // Status & Monitoring Obat
 
   Route::get('/master_obat/kadaluarsa', [MasterObatController::class, 'kadaluarsa'])
        ->name('master_obat.kadaluarsa');

    // Nonaktifkan obat
    Route::patch('/master_obat/{id}/nonaktifkan', [MasterObatController::class, 'nonAktifkan'])
        ->name('master_obat.nonaktifkan');

    // Aktifkan obat
    Route::patch('/master_obat/{id}/aktifkan', [MasterObatController::class, 'aktifkan'])
        ->name('master_obat.aktifkan');

    Route::get('master_obat/stok_menipis', [MasterObatController::class, 'stokMenipis'])
        ->name('master_obat.stok_menipis');

    
    // CRUD Obat
    Route::resource('obats', ObatController::class);

    Route::resource('master_obat', MasterObatController::class);


    Route::get('/pembelian/{id}/cetak', [PembelianController::class, 'cetak'])->name('pembelian.cetak');

    // Autocomplete Obat (kalau dipakai)
    Route::get('obats/autocomplete', [ObatController::class, 'autocomplete'])->name('obats.autocomplete');

    // Pencarian cepat (opsional)
    Route::get('obat-search', [ObatController::class, 'search'])->name('obat.search');

    // Kategori, Supplier, User
    Route::resource('kategoris', KategoriController::class);
    Route::resource('users', UserManagementController::class);
    Route::resource('suppliers', SupplierController::class);

    // Laporan PDF
    Route::get('laporan/harian/pdf', [AdminLaporanController::class, 'cetakHarian'])->name('laporan.harian.pdf');
    Route::get('laporan/mingguan/pdf', [AdminLaporanController::class, 'cetakMingguan'])->name('laporan.mingguan.pdf');
    Route::get('laporan/bulanan/pdf', [AdminLaporanController::class, 'cetakBulanan'])->name('laporan.bulanan.pdf');

    Route::resource('pembelian', PembelianController::class)->except(['edit', 'update']);
});


// ===================== DOKTER ROUTES =====================
Route::middleware(['auth', 'role:dokter'])->prefix('dokter')->name('dokter.')->group(function () {
    Route::get('/dashboard', [DokterController::class, 'dashboard'])->name('dashboard');
    Route::resource('reseps', ResepController::class);
    Route::post('/reseps/store-multiple', [ResepController::class, 'storeMultiple'])->name('dokter.reseps.storeMultiple');
    Route::post('/reseps/{resep}/obats', [ResepObatController::class, 'store'])->name('reseps.obats.store');
    Route::delete('/reseps/obats/{id}', [ResepObatController::class, 'destroy'])->name('reseps.obats.destroy');
    Route::get('/obat-diresepkan', [DokterController::class, 'obatDiresepkan'])->name('obat.diresepkan');
    Route::get('/obat-belum-diresepkan', [DokterController::class, 'obatBelumDiresepkan'])->name('obat.belum');
    Route::get('/dokter/obat-search', [App\Http\Controllers\ObatController::class, 'search'])->name('dokter.obat.search');
    Route::get('/rekam-medik', [RekamMedikController::class, 'index'])->name('rekammedik.index');
    Route::get('/rekam-medik/create', [RekamMedikController::class, 'create'])->name('rekammedik.create');
    Route::post('/rekam-medik', [RekamMedikController::class, 'store'])->name('rekammedik.store');
});

// ===================== KARYAWAN ROUTES =====================
Route::middleware(['auth', 'role:karyawan'])->prefix('karyawan')->name('karyawan.')->group(function () {
    Route::get('/dashboard', [KaryawanController::class, 'dashboard'])->name('dashboard');
    Route::get('/obat', [ObatController::class, 'index'])->name('obat.index');
   Route::get('/transaksi', [TransaksiController::class, 'index'])->name('transaksi.index');
    Route::get('/transaksi/create', [TransaksiController::class, 'create'])->name('transaksi.create');
    Route::post('/transaksi', [TransaksiController::class, 'store'])->name('transaksi.store');

    // Daftar rekam medik untuk ditebus
    Route::get('transaksi', [TransaksiController::class, 'index'])->name('transaksi.index');
    Route::get('transaksi/create', [TransaksiController::class, 'create'])->name('transaksi.create');
    Route::post('transaksi', [TransaksiController::class, 'store'])->name('transaksi.store');
    Route::get('transaksi/{id}', [TransaksiController::class, 'show'])->name('transaksi.show');

    // 📌 Rekam medik → Tebus obat
    Route::get('rekam-medik', [TransaksiController::class, 'listRekamMedik'])->name('transaksi.rekam_medik.list');
    Route::get('rekam-medik/{rekamMedikId}/tebus', [TransaksiController::class, 'createFromRekamMedik'])->name('transaksi.rekam_medik');
    Route::post('rekam-medik/{rekamMedikId}/tebus', [TransaksiController::class, 'storeFromRekamMedik'])->name('transaksi.rekam_medik.store');
    Route::get('riwayat-rekam-medik', [TransaksiController::class, 'riwayatRekamMedik'])->name('riwayat_rekam_medik');
    Route::get('rekam-medik/{id}/print', [TransaksiController::class, 'printRekamMedik'])->name('print_rekam_medik');

    // Detail transaksi
    Route::get('/transaksi/{id}', [TransaksiController::class, 'show'])->name('transaksi.show');
    Route::get('/get-resep-by-obat/{obatId}', [TransaksiController::class, 'getResepByObat']);
    Route::get('/obat-search', [TransaksiController::class, 'searchObat'])->name('karyawan.obat.search');
    Route::get('/transaksi/{id}/print', [TransaksiController::class, 'print'])->name('karyawan.transaksi.print');
    Route::get('/obat/{id}/search', [KaryawanObatController::class, 'search'])->name('karyawan.obat.search');
    Route::get('/obat/{id}/autocomplete', [KaryawanObatController::class, 'autocomplete'])->name('karyawan.obat.autocomplete');
    Route::get('/transaksi/{resep}', [TransaksiController::class, 'show'])->name('transaksi.show');
    Route::get('/transaksi/{resep}/print', [TransaksiController::class, 'print'])->name('transaksi.print');
    Route::get('/karyawan/transaksi/{id}', [TransaksiController::class, 'show'])->name('karyawan.transaksi.show');
    Route::get('/karyawan/transaksi/{id}/print', [TransaksiController::class, 'print'])->name('karyawan.transaksi.print');
    
        Route::get('/karyawan/obat-search', function (Illuminate\Http\Request $request) {
        $search = $request->query('q');
        $obats = \App\Models\Obat::where('nama', 'like', "%{$search}%")
            ->select('id', 'nama', 'stok')
            ->limit(10)
            ->get();
        return response()->json($obats);
    });


        Route::get('/karyawan/cari-obat', function (\Illuminate\Http\Request $request) {
        $search = $request->get('term'); // jQuery UI pakai ?term=
        $results = \App\Models\Obat::where('nama', 'like', '%' . $search . '%')
            ->select('id', 'nama', 'stok')
            ->limit(10)
            ->get();

        return response()->json($results->map(function ($obat) {
            return [
                'label' => $obat->nama . ' (Stok: ' . $obat->stok . ')',
                'value' => $obat->nama,
                'id' => $obat->id
            ];
        }));
    })->name('karyawan.obat.autocomplete');
});
