@extends('karyawan.layout')

@section('content')
<div class="bg-white rounded-xl shadow p-6">
    <h2 class="text-2xl font-bold mb-4">Riwayat Transaksi</h2>

    <a href="{{ route('karyawan.transaksi.create') }}" class="bg-blue-600 text-white px-4 py-2 rounded-lg mb-4 inline-block">
        + Transaksi Baru
    </a>

    <table class="min-w-full divide-y divide-gray-200 text-sm">
        <thead class="bg-gray-50">
            <tr>
                <th class="px-4 py-2 text-left font-medium">Tanggal</th>
                <th class="px-4 py-2 text-left font-medium">Total</th>
                <th class="px-4 py-2 text-left font-medium">Kasir</th>
                <th class="px-4 py-2 text-left font-medium">Aksi</th>
            </tr>
        </thead>
        <tbody class="divide-y divide-gray-100">
            @foreach ($transaksis as $transaksi)
            <tr>
                <td class="px-4 py-2">{{ $transaksi->tanggal_transaksi->format('d/m/Y H:i') }}</td>
                <td class="px-4 py-2">Rp{{ number_format($transaksi->total, 0, ',', '.') }}</td>
                <td class="px-4 py-2">{{ $transaksi->user->name }}</td>
                <td class="px-4 py-2">
                    <a href="{{ route('karyawan.transaksi.show', $transaksi->id) }}" class="text-blue-600 hover:underline">Detail</a>
                </td>
            </tr>
            @endforeach
        </tbody>
    </table>
</div>
@endsection
