@extends('karyawan.layout')

@section('content')
<div class="bg-white rounded-xl shadow p-6">
    <h2 class="text-2xl font-bold mb-4">Buat Transaksi Baru</h2>

    <form action="{{ route('karyawan.transaksi.store') }}" method="POST">
        @csrf

        <div class="mb-4">
            <label class="block text-sm font-medium mb-1">Tanggal Transaksi</label>
            <input type="datetime-local" name="tanggal_transaksi" value="{{ now()->format('Y-m-d\TH:i') }}" 
                class="border rounded-lg w-full p-2" required>
        </div>

        <div class="mb-4">
            <label class="block text-sm font-medium mb-1">Pilih Obat</label>
            <select name="items[0][obat_id]" class="border rounded-lg w-full p-2" required>
                @foreach($obats as $obat)
                    <option value="{{ $obat->id }}">
                        {{ $obat->masterObat->nama }} - Rp{{ number_format($obat->harga_jual, 0, ',', '.') }} - Sisa: {{ $obat->jumlah }}
                    </option>
                @endforeach
            </select>
        </div>

        <div class="mb-4">
            <label class="block text-sm font-medium mb-1">Jumlah</label>
            <input type="number" name="items[0][jumlah]" class="border rounded-lg w-full p-2" min="1" required>
        </div>

        <button type="submit" class="bg-blue-600 text-white px-4 py-2 rounded-lg hover:bg-blue-700">
            Simpan Transaksi
        </button>
    </form>
</div>
@endsection
