@extends('karyawan.layout')

@section('content')
<div class="container mx-auto px-4 py-6">
    <h2 class="text-2xl font-bold mb-4">Daftar Obat</h2>

    <!-- Input pencarian -->
    <input type="text" id="cari" placeholder="Cari Obat..." class="border px-2 py-1 rounded mb-4" />

    <!-- Tempat tampilkan tabel -->
    <div id="obat-list">
        @include('karyawan.obat.data', ['obats' => $obats])
    </div>
</div>
@endsection

@push('scripts')
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
    $('#cari').on('keyup', function () {
        let keyword = $(this).val();

        $.ajax({
            url: "{{ route('karyawan.obat.index') }}",
            type: "GET",
            data: { cari: keyword },
            success: function (res) {
                $('#obat-list').html(res); // Ganti hanya isi div, bukan append
            }
        });
    });
</script>
@endpush
