@extends('karyawan.layout')

@section('content')
<div class="max-w-7xl mx-auto px-4 py-6">
    <!-- Header dengan gradient -->
    <div class="mb-8">
        <h1 class="text-3xl font-bold text-gray-900 mb-2">📊 Dashboard Karyawan</h1>
        <p class="text-gray-600">Selamat datang, {{ Auth::user()->name ?? 'Karyawan' }}! Berikut ringkasan aktivitas hari ini.</p>
    </div>

    <!-- Statistik Cards -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6 mb-8">
        <!-- Total Omzet Card -->
        <div class="bg-white rounded-xl shadow-lg overflow-hidden border-l-4 border-blue-500 transition-all duration-300 hover:shadow-xl">
            <div class="p-6 flex items-center">
                <div class="bg-blue-100 p-4 rounded-xl mr-4">
                    <i class="fas fa-money-bill-wave text-blue-600 text-xl"></i>
                </div>
                <div>
                    <h2 class="text-sm font-semibold text-gray-600 mb-1">Total Omzet Hari Ini</h2>
                    <p class="text-2xl font-bold text-gray-800">Rp {{ number_format($totalHariIni, 0, ',', '.') }}</p>
                    <div class="flex items-center mt-2">
                        <span class="text-xs py-1 px-2 bg-blue-100 text-blue-700 rounded-full">
                            <i class="fas fa-calendar-day mr-1"></i> {{ date('d M Y') }}
                        </span>
                    </div>
                </div>
            </div>
        </div>

        <!-- Total Obat Terjual Card -->
        <div class="bg-white rounded-xl shadow-lg overflow-hidden border-l-4 border-green-500 transition-all duration-300 hover:shadow-xl">
            <div class="p-6 flex items-center">
                <div class="bg-green-100 p-4 rounded-xl mr-4">
                    <i class="fas fa-pills text-green-600 text-xl"></i>
                </div>
                <div>
                    <h2 class="text-sm font-semibold text-gray-600 mb-1">Total Obat Terjual</h2>
                    <p class="text-2xl font-bold text-gray-800">{{ $totalObatTerjual }} item</p>
                    <div class="flex items-center mt-2">
                        <span class="text-xs py-1 px-2 bg-green-100 text-green-700 rounded-full">
                            <i class="fas fa-chart-line mr-1"></i> Hari ini
                        </span>
                    </div>
                </div>
            </div>
        </div>

        <!-- Jenis Obat Terjual Card -->
        <div class="bg-white rounded-xl shadow-lg overflow-hidden border-l-4 border-purple-500 transition-all duration-300 hover:shadow-xl">
            <div class="p-6 flex items-center">
                <div class="bg-purple-100 p-4 rounded-xl mr-4">
                    <i class="fas fa-capsules text-purple-600 text-xl"></i>
                </div>
                <div>
                    <h2 class="text-sm font-semibold text-gray-600 mb-1">Jenis Obat Terjual</h2>
                    <p class="text-2xl font-bold text-gray-800">{{ count($obatTerjualHariIni) }} jenis</p>
                    <div class="flex items-center mt-2">
                        <span class="text-xs py-1 px-2 bg-purple-100 text-purple-700 rounded-full">
                            <i class="fas fa-boxes mr-1"></i> Varietas
                        </span>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Quick Actions -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4 mb-8">
        <a href="{{ route('karyawan.transaksi.create') }}" class="bg-white rounded-lg shadow p-4 flex flex-col items-center justify-center transition-all duration-300 hover:shadow-lg hover:bg-blue-50 border border-blue-100">
            <div class="bg-blue-100 p-3 rounded-full mb-3">
                <i class="fas fa-cash-register text-blue-600 text-xl"></i>
            </div>
            <h3 class="font-semibold text-gray-800 text-center">Transaksi Baru</h3>
            <p class="text-xs text-gray-500 text-center mt-1">Tanpa resep</p>
        </a>

        <a href="{{ route('karyawan.transaksi.index') }}" class="bg-white rounded-lg shadow p-4 flex flex-col items-center justify-center transition-all duration-300 hover:shadow-lg hover:bg-green-50 border border-green-100">
            <div class="bg-green-100 p-3 rounded-full mb-3">
                <i class="fas fa-history text-green-600 text-xl"></i>
            </div>
            <h3 class="font-semibold text-gray-800 text-center">Riwayat Transaksi</h3>
            <p class="text-xs text-gray-500 text-center mt-1">Lihat semua</p>
        </a>

        <a href="{{ route('karyawan.transaksi.rekam_medik.list') }}" class="bg-white rounded-lg shadow p-4 flex flex-col items-center justify-center transition-all duration-300 hover:shadow-lg hover:bg-purple-50 border border-purple-100">
            <div class="bg-purple-100 p-3 rounded-full mb-3">
                <i class="fas fa-notes-medical text-purple-600 text-xl"></i>
            </div>
            <h3 class="font-semibold text-gray-800 text-center">Rekam Medik</h3>
            <p class="text-xs text-gray-500 text-center mt-1">Kelola data</p>
        </a>

        <div class="bg-white rounded-lg shadow p-4 flex flex-col items-center justify-center border border-gray-100">
            <div class="bg-gray-100 p-3 rounded-full mb-3">
                <i class="fas fa-chart-bar text-gray-600 text-xl"></i>
            </div>
            <h3 class="font-semibold text-gray-800 text-center">Laporan</h3>
            <p class="text-xs text-gray-500 text-center mt-1">Bulanan</p>
        </div>
    </div>

    <!-- Detail Obat -->
    <div class="bg-white rounded-2xl shadow-lg overflow-hidden">
        <div class="border-b border-gray-200 px-6 py-4 flex justify-between items-center">
            <h2 class="text-lg font-semibold text-gray-800">📝 Detail Obat Terjual Hari Ini</h2>
            <span class="text-xs bg-blue-100 text-blue-700 py-1 px-3 rounded-full">
                {{ date('d F Y') }}
            </span>
        </div>
        <div class="p-6">
            @if(count($obatTerjualHariIni) > 0)
            <div class="relative overflow-x-auto">
                <table class="w-full text-sm text-left text-gray-700">
                    <thead class="text-xs text-gray-700 uppercase bg-gray-50">
                        <tr>
                            <th scope="col" class="px-4 py-3">Nama Obat</th>
                            <th scope="col" class="px-4 py-3">Jumlah Terjual</th>
                            <th scope="col" class="px-4 py-3">Status</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($obatTerjualHariIni as $obat)
                        <tr class="bg-white border-b hover:bg-gray-50 transition-colors">
                            <td class="px-4 py-3 font-medium text-gray-900">{{ $obat['nama'] }}</td>
                            <td class="px-4 py-3">
                                <span class="bg-blue-100 text-blue-800 text-xs font-medium px-2.5 py-0.5 rounded-full">
                                    {{ $obat['jumlah'] }} item
                                </span>
                            </td>
                            <td class="px-4 py-3">
                                @if($obat['jumlah'] > 10)
                                <span class="bg-green-100 text-green-800 text-xs font-medium px-2.5 py-0.5 rounded-full">Laris</span>
                                @elseif($obat['jumlah'] > 5)
                                <span class="bg-yellow-100 text-yellow-800 text-xs font-medium px-2.5 py-0.5 rounded-full">Sedang</span>
                                @else
                                <span class="bg-gray-100 text-gray-800 text-xs font-medium px-2.5 py-0.5 rounded-full">Normal</span>
                                @endif
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
            @else
            <div class="text-center py-10">
                <div class="inline-block bg-gray-100 p-4 rounded-full mb-4">
                    <i class="fas fa-inbox text-gray-400 text-3xl"></i>
                </div>
                <h3 class="text-lg font-medium text-gray-600 mb-1">Tidak ada transaksi hari ini</h3>
                <p class="text-gray-500 text-sm">Mulai lakukan transaksi untuk melihat data di sini</p>
                <a href="{{ route('karyawan.transaksi.create') }}" class="mt-4 inline-flex items-center px-4 py-2 bg-blue-600 border border-transparent rounded-md font-semibold text-xs text-white uppercase tracking-widest hover:bg-blue-700 active:bg-blue-900 focus:outline-none focus:border-blue-900 focus:ring ring-blue-300 disabled:opacity-25 transition ease-in-out duration-150">
                    <i class="fas fa-plus mr-2"></i> Transaksi Baru
                </a>
            </div>
            @endif
        </div>
    </div>

    <!-- Grafik Placeholder -->
    <div class="mt-8 bg-white rounded-2xl shadow-lg overflow-hidden">
        <div class="border-b border-gray-200 px-6 py-4">
            <h2 class="text-lg font-semibold text-gray-800">📈 Grafik Penjualan 7 Hari Terakhir</h2>
        </div>
        <div class="p-6">
            <div class="h-64 flex items-center justify-center bg-gray-50 rounded-lg">
                <div class="text-center">
                    <i class="fas fa-chart-line text-gray-300 text-4xl mb-3"></i>
                    <p class="text-gray-500">Fitur grafik akan segera hadir</p>
                    <p class="text-sm text-gray-400 mt-1">Sedang dalam pengembangan</p>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Animasi untuk cards saat dimuat
        const cards = document.querySelectorAll('.bg-white');
        cards.forEach((card, index) => {
            card.style.opacity = '0';
            card.style.transform = 'translateY(20px)';
            
            setTimeout(() => {
                card.style.transition = 'opacity 0.5s ease, transform 0.5s ease';
                card.style.opacity = '1';
                card.style.transform = 'translateY(0)';
            }, index * 100);
        });
    });
</script>
@endsection