@extends('dokter.layout')

@section('content')
<div class="space-y-6">
    <!-- Header -->
    <div class="flex flex-col md:flex-row md:items-center md:justify-between">
        <div>
            <h1 class="text-2xl font-bold text-gray-900 flex items-center">
                <i class="fas fa-file-prescription text-indigo-600 mr-3"></i>Daftar Resep Obat
            </h1>
            <p class="text-gray-600 mt-2">Kelola semua resep obat yang telah dibuat</p>
        </div>
        <a href="{{ route('dokter.reseps.create') }}" class="bg-indigo-600 hover:bg-indigo-700 text-white px-5 py-2.5 rounded-xl shadow-md flex items-center transition mt-4 md:mt-0">
            <i class="fas fa-plus-circle mr-2"></i> Buat Resep Baru
        </a>
    </div>

    <!-- Search Form -->
    <div class="bg-white p-5 rounded-xl shadow-md">
        <form method="GET" action="{{ route('dokter.reseps.index') }}" class="space-y-4 md:space-y-0 md:grid md:grid-cols-3 md:gap-4">
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-1">Cari Kode Resep</label>
                <input 
                    type="text" 
                    name="q" 
                    value="{{ request('q') }}" 
                    placeholder="Masukkan kode resep..." 
                    class="w-full px-4 py-2.5 border border-gray-300 rounded-lg focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500"
                >
            </div>
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-1">Cari Nama Obat</label>
                <input 
                    type="text" 
                    name="obat" 
                    value="{{ request('obat') }}" 
                    placeholder="Masukkan nama obat..." 
                    class="w-full px-4 py-2.5 border border-gray-300 rounded-lg focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500"
                >
            </div>
            <div class="flex items-end">
                <button type="submit" class="bg-indigo-600 hover:bg-indigo-700 text-white px-4 py-2.5 rounded-lg w-full flex items-center justify-center transition">
                    <i class="fas fa-search mr-2"></i> Cari Resep
                </button>
            </div>
        </form>
    </div>

    <!-- Tabel Resep -->
    <div class="bg-white rounded-xl shadow-md overflow-hidden">
        <div class="overflow-x-auto">
            <table class="w-full text-sm">
                <thead class="bg-gray-50">
                    <tr class="text-left text-gray-700">
                        <th class="px-6 py-4 font-medium">Kode Resep</th>
                        <th class="px-6 py-4 font-medium">Tanggal Dibuat</th>
                        <th class="px-6 py-4 font-medium">Detail Obat</th>
                        <th class="px-6 py-4 font-medium text-right">Aksi</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-100">
                    @forelse ($reseps as $resep)
                        <tr class="hover:bg-gray-50 transition">
                            <td class="px-6 py-4">
                                <div class="font-medium text-indigo-600">#{{ $resep->kode_resep }}</div>
                            </td>
                            <td class="px-6 py-4">
                                <div class="text-gray-900">{{ $resep->created_at->format('d M Y') }}</div>
                                <div class="text-xs text-gray-500">{{ $resep->created_at->format('H:i') }}</div>
                            </td>
                            <td class="px-6 py-4">
                                @forelse ($resep->resepObats as $item)
                                    <div class="mb-2 last:mb-0">
                                        <div class="font-medium text-gray-800">{{ $item->obat->nama }}</div>
                                        <div class="text-xs text-gray-600">
                                            <span class="bg-blue-100 text-blue-800 px-2 py-0.5 rounded-full">Dosis: {{ $item->dosis }}</span>
                                            <span class="bg-green-100 text-green-800 px-2 py-0.5 rounded-full ml-1">Aturan: {{ $item->aturan_pakai }}</span>
                                        </div>
                                    </div>
                                @empty
                                    <span class="text-gray-500 italic">Tidak ada obat</span>
                                @endforelse
                            </td>
                            <td class="px-6 py-4">
                                <div class="flex justify-end space-x-2">
                                    <a href="{{ route('dokter.reseps.show', $resep->id) }}" class="bg-blue-100 hover:bg-blue-200 text-blue-800 p-2 rounded-lg transition" title="Lihat Detail">
                                        <i class="fas fa-eye"></i>
                                    </a>
                                    <a href="{{ route('dokter.reseps.edit', $resep->id) }}" class="bg-yellow-100 hover:bg-yellow-200 text-yellow-800 p-2 rounded-lg transition" title="Edit">
                                        <i class="fas fa-edit"></i>
                                    </a>
                                    <form action="{{ route('dokter.reseps.destroy', $resep->id) }}" method="POST" class="inline" onsubmit="return confirm('Apakah Anda yakin ingin menghapus resep ini?')">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="bg-red-100 hover:bg-red-200 text-red-800 p-2 rounded-lg transition" title="Hapus">
                                            <i class="fas fa-trash-alt"></i>
                                        </button>
                                    </form>
                                </div>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="4" class="px-6 py-8 text-center">
                                <div class="flex flex-col items-center justify-center text-gray-400">
                                    <i class="fas fa-file-medical text-4xl mb-3"></i>
                                    <p>Belum ada resep obat.</p>
                                    <p class="text-sm mt-2">Klik "Buat Resep Baru" untuk membuat resep pertama Anda.</p>
                                </div>
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>

    <!-- Pagination -->
    @if($reseps->hasPages())
    <div class="bg-white px-6 py-4 rounded-xl shadow-md">
        {{ $reseps->withQueryString()->links() }}
    </div>
    @endif
</div>

<style>
    .pagination {
        display: flex;
        justify-content: center;
        list-style-type: none;
        padding: 0;
    }
    
    .pagination li {
        margin: 0 4px;
    }
    
    .pagination li a,
    .pagination li span {
        display: inline-block;
        padding: 8px 12px;
        border-radius: 6px;
        border: 1px solid #e5e7eb;
        color: #4b5563;
        text-decoration: none;
        transition: all 0.2s;
    }
    
    .pagination li a:hover {
        background-color: #f3f4f6;
    }
    
    .pagination li.active span {
        background-color: #4f46e5;
        color: white;
        border-color: #4f46e5;
    }
    
    .pagination li.disabled span {
        color: #9ca3af;
        cursor: not-allowed;
    }
</style>

<!-- Include Font Awesome -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

@endsection