@extends('dokter.layout')

@section('content')
<div class="bg-white p-6 rounded-xl shadow">
    <h2 class="text-xl font-semibold mb-4">Riwayat Rekam Medik</h2>

    <table class="min-w-full divide-y divide-gray-200 text-sm">
        <thead class="bg-gray-100">
            <tr>
                <th class="px-4 py-2 text-left">Pasien</th>
                <th class="px-4 py-2 text-left">Umur</th>
                <th class="px-4 py-2 text-left">Dokter</th>
                <th class="px-4 py-2 text-left">Keluhan</th>
                <th class="px-4 py-2 text-left">Obat</th>
                <th class="px-4 py-2 text-left">Tanggal</th>
            </tr>
        </thead>
        <tbody class="divide-y divide-gray-100">
            @forelse ($rekamMediks as $rekam)
                <tr>
                    <td class="px-4 py-2">{{ $rekam->nama_pasien }}</td>
                    <td class="px-4 py-2">{{ $rekam->umur }} th</td>
                    <td class="px-4 py-2">{{ $rekam->dokter->name }}</td>
                    <td class="px-4 py-2">{{ $rekam->keluhan }}</td>
                    <td class="px-4 py-2">
                        @if($rekam->resep && $rekam->resep->resepObats)
                            <ul>
                                @foreach($rekam->resep->resepObats as $item)
                                    <li>{{ $item->obat->nama }} ({{ $item->dosis }})</li>
                                @endforeach
                            </ul>
                        @else
                            <span class="text-gray-400 italic">-</span>
                        @endif
                    </td>
                    <td class="px-4 py-2">{{ $rekam->created_at->format('d/m/Y') }}</td>
                </tr>
            @empty
                <tr>
                    <td colspan="6" class="px-4 py-4 text-center text-gray-500">Belum ada rekam medik.</td>
                </tr>
            @endforelse
        </tbody>
    </table>
</div>
@endsection