@extends('dokter.layout')

@section('content')
<div class="bg-white rounded-xl shadow p-6">
    <h2 class="text-xl font-semibold text-gray-800 mb-4">🕵️ Obat Belum Diresepkan</h2>
    <table class="min-w-full divide-y divide-gray-200 text-sm">
        <thead class="bg-gray-100 text-gray-600">
            <tr>
                <th class="px-4 py-2 text-left">Nama Obat</th>
                <th class="px-4 py-2 text-left">Stok</th>
                <th class="px-4 py-2 text-left">Harga</th>
                <th class="px-4 py-2 text-left">Expired</th>
                <th class="px-4 py-2 text-left">Aksi</th>
            </tr>
        </thead>
        <tbody class="bg-white divide-y divide-gray-100">
            @forelse($obats as $obat)
                <tr>
                    <td class="px-4 py-2">{{ $obat->nama }}</td>
                    <td class="px-4 py-2">{{ $obat->stok }}</td>
                    <td class="px-4 py-2">Rp {{ number_format($obat->harga, 0, ',', '.') }}</td>
                    <td class="px-4 py-2">{{ $obat->expired_at }}</td>
                    <td class="px-4 py-2">
                        <a href="{{ route('dokter.reseps.create', ['obat_id' => $obat->id]) }}"
                           class="text-indigo-600 hover:underline text-sm">➕ Tambah Resep</a>
                    </td>
                </tr>
            @empty
                <tr>
                    <td colspan="5" class="text-center px-4 py-2 text-gray-500">Semua obat sudah diresepkan.</td>
                </tr>
            @endforelse
        </tbody>
    </table>

    <div class="mt-4">
        {{ $obats->links('pagination::tailwind') }}
    </div>
</div>
@endsection
