@extends('admin.layout')

@section('content')
<h1 class="text-2xl font-bold mb-6">Edit Obat</h1>

<form action="{{ route('admin.obats.update', $obat->id) }}" method="POST" class="space-y-4">
    @csrf @method('PUT')

    <div>
        <label class="block font-medium">Nama Obat</label>
        <input type="text" name="nama" value="{{ $obat->nama }}" class="w-full border rounded px-3 py-2" required>
    </div>

    <div>
        <label class="block font-medium">Kategori</label>
        <select name="kategori_id" class="w-full border rounded px-3 py-2" required>
            @foreach ($kategoris as $kategori)
                <option value="{{ $kategori->id }}" {{ $obat->kategori_id == $kategori->id ? 'selected' : '' }}>
                    {{ $kategori->nama }}
                </option>
            @endforeach
        </select>
    </div>

    <div>
        <label class="block font-medium">Satuan</label>
        <input type="text" name="satuan" value="{{ $obat->satuan }}" class="w-full border rounded px-3 py-2" required>
    </div>

    <div>
        <label class="block font-medium">Stok</label>
        <input type="number" name="stok" value="{{ $obat->stok }}" class="w-full border rounded px-3 py-2" required>
    </div>

    <div>
        <label class="block font-medium">Harga</label>
        <input type="number" name="harga" value="{{ $obat->harga }}" class="w-full border rounded px-3 py-2" required>
    </div>

    <div>
        <label class="block font-medium">Tanggal Expired</label>
       <input type="date" name="expired_at" value="{{ \Carbon\Carbon::parse($obat->expired_at)->format('Y-m-d') }}" class="w-full border rounded px-3 py-2" required>
    </div>

    <div class="mt-4">
        <button type="submit" class="bg-blue-600 text-white px-4 py-2 rounded hover:bg-blue-700">Update</button>
    </div>
</form>
@endsection
