@extends('admin.layout')

@section('content')
<div class="mb-6">
    <h1 class="text-2xl font-bold mb-4">📉 Obat dengan Stok Menipis</h1>

    @if ($obats->isEmpty())
        <div class="bg-yellow-100 text-yellow-800 p-4 rounded-lg">
            Tidak ada obat dengan stok menipis saat ini.
        </div>
    @else
        <div class="overflow-x-auto bg-white shadow rounded-lg">
            <table class="min-w-full table-auto border-collapse">
                <thead class="bg-gray-100">
                    <tr>
                        <th class="px-4 py-2 text-left">Nama Obat</th>
                        <th class="px-4 py-2 text-left">Kategori</th>
                        <th class="px-4 py-2 text-center">Stok Tersedia</th>
                        <th class="px-4 py-2 text-center">Status</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-200">
                    @foreach ($obats as $obat)
                        <tr>
                            <td class="px-4 py-2 font-medium text-gray-800">
                                {{ $obat->nama }}
                            </td>
                            <td class="px-4 py-2">{{ $obat->kategori->nama ?? '-' }}</td>
                            <td class="px-4 py-2 text-center">
                                <span class="px-2 py-1 text-sm rounded-lg bg-red-100 text-red-800 font-semibold">
                                    {{ $obat->stok_tersedia ?? 0 }}
                                </span>
                            </td>
                            <td class="px-4 py-2 text-center">
                                <span class="px-2 py-1 text-xs rounded-lg {{ $obat->status === 'aktif' ? 'bg-green-100 text-green-800' : 'bg-gray-200 text-gray-600' }}">
                                    {{ ucfirst($obat->status) }}
                                </span>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    @endif
</div>
@endsection
