{{-- resources/views/admin/master_obat/edit.blade.php --}}
@extends('admin.layout')

@section('content')
<div class="max-w-2xl mx-auto bg-white p-6 rounded-xl shadow">
    <h1 class="text-2xl font-bold mb-6 text-gray-800">✏️ Edit Master Obat</h1>

    @if ($errors->any())
        <div class="bg-red-50 border border-red-400 text-red-700 px-4 py-3 rounded-lg mb-4">
            <ul class="list-disc pl-5 space-y-1">
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <form action="{{ route('admin.master_obat.update', $obat->id) }}" method="POST" class="space-y-5">
        @csrf
        @method('PUT')

        {{-- Nama Obat --}}
        <div>
            <label for="nama" class="block text-sm font-medium text-gray-700">Nama Obat <span class="text-red-500">*</span></label>
            <input type="text" name="nama" id="nama"
                   value="{{ old('nama', $obat->nama) }}"
                   class="mt-1 block w-full border-gray-300 rounded-lg shadow-sm focus:ring focus:ring-blue-200 focus:border-blue-500" required>
        </div>

        {{-- Kategori --}}
        <div>
            <label for="kategori_id" class="block text-sm font-medium text-gray-700">Kategori <span class="text-red-500">*</span></label>
            <select name="kategori_id" id="kategori_id"
                    class="mt-1 block w-full border-gray-300 rounded-lg shadow-sm focus:ring focus:ring-blue-200 focus:border-blue-500" required>
                <option value="">-- Pilih Kategori --</option>
                @foreach ($kategoris as $kategori)
                    <option value="{{ $kategori->id }}"
                        {{ (int) old('kategori_id', $obat->kategori_id) === (int) $kategori->id ? 'selected' : '' }}>
                        {{ $kategori->nama }}
                    </option>
                @endforeach
            </select>
        </div>

        <div class="flex items-center gap-3 pt-3">
            <a href="{{ route('admin.master_obat.index') }}"
               class="bg-gray-500 hover:bg-gray-600 text-white px-5 py-2 rounded-lg shadow-sm transition">
                ⬅️ Kembali
            </a>
            <button type="submit"
                    class="bg-blue-600 hover:bg-blue-700 text-white px-5 py-2 rounded-lg shadow-sm transition">
                💾 Simpan Perubahan
            </button>
        </div>
    </form>
</div>
@endsection
