@extends('admin.layout')

@section('content')
<div class="bg-white p-6 rounded-xl shadow-lg">
    <h1 class="text-2xl font-bold mb-6 text-gray-800">➕ Tambah Master Obat</h1>

    @if ($errors->any())
        <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded-lg mb-4">
            <ul class="list-disc list-inside text-sm">
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <form action="{{ route('admin.master_obat.store') }}" method="POST" class="space-y-5">
        @csrf

        {{-- Nama Obat --}}
        <div>
            <label for="nama" class="block text-sm font-medium text-gray-700">Nama Obat</label>
            <input type="text" name="nama" id="nama" value="{{ old('nama') }}" 
                   class="mt-1 block w-full border-gray-300 rounded-lg shadow-sm focus:border-blue-500 focus:ring focus:ring-blue-200 focus:ring-opacity-50" 
                   placeholder="Masukkan nama obat" required>
        </div>

        {{-- Kategori Obat --}}
        <div>
            <label for="kategori_id" class="block text-sm font-medium text-gray-700">Kategori Obat</label>
            <select name="kategori_id" id="kategori_id" 
                    class="mt-1 block w-full border-gray-300 rounded-lg shadow-sm focus:border-blue-500 focus:ring focus:ring-blue-200 focus:ring-opacity-50" 
                    required>
                <option value="">-- Pilih Kategori --</option>
                @foreach($kategoris as $kategori)
                    <option value="{{ $kategori->id }}" {{ old('kategori_id') == $kategori->id ? 'selected' : '' }}>
                        {{ $kategori->nama }}
                    </option>
                @endforeach
            </select>
        </div>

        {{-- Tombol Aksi --}}
        <div class="flex items-center gap-3 pt-3">
            <button type="submit" 
                    class="bg-blue-600 hover:bg-blue-700 text-white px-5 py-2 rounded-lg shadow-sm transition">
                💾 Simpan
            </button>
            <a href="{{ route('admin.master_obat.index') }}" 
               class="bg-gray-500 hover:bg-gray-600 text-white px-5 py-2 rounded-lg shadow-sm transition">
                ❌ Batal
            </a>
        </div>
    </form>
</div>
@endsection
