<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class PembelianDetail extends Model
{
    protected $fillable = [
        'pembelian_id',
        'master_obat_id',
        'kode_barcode',
        'jumlah',
        'satuan',
        'harga_beli',
        'harga_jual',
        'expired_at',
        'subtotal'
    ];

    public function pembelian()
    {
        return $this->belongsTo(Pembelian::class);
    }

    public function masterObat()
    {
        return $this->belongsTo(MasterObat::class, 'master_obat_id');
    }
}
