<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Obat extends Model
{
    protected $fillable = [
        'nama', 'kategori_id', 'satuan', 'stok', 'harga', 'expired_at', 'status'
    ];

    public function kategori()
    {
        return $this->belongsTo(Kategori::class);
    }

    public function resepObats()
    {
        return $this->hasMany(ResepObat::class);
    }

    public function reseps()
    {
        return $this->belongsToMany(Resep::class, 'resep_obats')
                    ->withPivot('dosis', 'aturan_pakai')
                    ->withTimestamps();
    }

    public function pembelians()
    {
        return $this->hasMany(Pembelian::class);
    }

    public function getSupplierTerakhirAttribute()
{
    $pembelianTerakhir = $this->pembelians->last();
    return $pembelianTerakhir && $pembelianTerakhir->supplier
        ? $pembelianTerakhir->supplier->nama
        : 'Belum Pernah Dibeli';
}
}
