<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class MasterObat extends Model
{
    use HasFactory;

    protected $table = 'master_obats'; // Nama tabel

    protected $fillable = [
        'nama',
        'kategori_id',
        'status',
    ];

    /**
     * Relasi ke kategori
     */
    public function kategori()
    {
        return $this->belongsTo(Kategori::class, 'kategori_id');
    }

    // relasi ke pembelian 
    public function pembelianDetails()
    {
        return $this->hasMany(PembelianDetail::class, 'master_obat_id');
    }

    public function transaksiDetails()
    {
        return $this->hasMany(Transaksi::class, 'master_obat_id');
    }

    public function reseps()
    {
        return $this->belongsToMany(Resep::class, 'resep_obats', 'master_obat_id', 'resep_id')
                    ->withPivot(['dosis', 'aturan_pakai'])
                    ->withTimestamps();
    }
    
}
