<?php

namespace App\Http\Controllers;

use App\Models\RekamMedik;
use App\Models\Resep;
use App\Models\ResepObat;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Str;

class RekamMedikController extends Controller
{
    public function index()
    {
        $rekamMediks = RekamMedik::with(['dokter', 'resep.resepObats.obat'])
            ->latest()
            ->paginate(10);

        return view('dokter.rekammedik.index', compact('rekamMediks'));
    }

    public function create()
    {
        $obats = \App\Models\MasterObat::where('status', 'aktif')->get();
        return view('dokter.rekammedik.create', compact('obats'));
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'nama_pasien' => 'required|string|max:255',
            'umur' => 'required|integer|min:0',
            'alamat' => 'nullable|string',
            'keluhan' => 'required|string',
            'indikasi' => 'nullable|string',
            'penanganan' => 'nullable|string',
            'obat_id' => 'required|array',
            'obat_id.*' => 'exists:master_obats,id',
            'dosis' => 'required|array',
            'dosis.*' => 'string',
            'jumlah' => 'required|array',
            'jumlah.*' => 'integer|min:1',
            'aturan_pakai' => 'required|array',
            'aturan_pakai.*' => 'string',
        ]);

        // Buat rekam medik
        $rekamMedik = RekamMedik::create([
            'nama_pasien' => $validated['nama_pasien'],
            'umur' => $validated['umur'],
            'alamat' => $validated['alamat'] ?? null,
            'keluhan' => $validated['keluhan'],
            'indikasi' => $validated['indikasi'] ?? null,
            'penanganan' => $validated['penanganan'] ?? null,
            'dokter_id' => Auth::id(),
        ]);

        // Buat resep
        $resep = Resep::create([
            'dokter_id' => Auth::id(),
            'kode_resep' => 'RSP-' . strtoupper(Str::random(6)),
        ]);

        // Hubungkan rekam medik ke resep
        $rekamMedik->update(['resep_id' => $resep->id]);

        // Tambah resep_obats
        foreach ($validated['obat_id'] as $index => $obatId) {
            ResepObat::create([
                'resep_id' => $resep->id,
                'obat_id' => $obatId,
                'dosis' => $validated['dosis'][$index],
                'jumlah' => $validated['jumlah'][$index],
                'aturan_pakai' => $validated['aturan_pakai'][$index],
            ]);
        }

        return redirect()->route('dokter.rekammedik.index')
            ->with('success', 'Rekam medik dan resep berhasil dibuat.');
    }
}
