<?php

namespace App\Http\Controllers;
use App\Models\Transaksi;
use App\Models\Obat;
use App\Models\TransaksiItem;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;


use Illuminate\Http\Request;

class KaryawanController extends Controller
{
    public function dashboard()
    {
        $userId = Auth::id();
        $today = Carbon::today();

        // Ambil semua transaksi hari ini oleh karyawan ini
        $transaksisHariIni = Transaksi::where('user_id', $userId)
            ->whereDate('tanggal_transaksi', $today)
            ->get();

        // Total omzet hari ini
        $totalHariIni = $transaksisHariIni->sum('total');

        // Ambil semua item transaksi hari ini
        $transaksiIds = $transaksisHariIni->pluck('id');
        $itemsHariIni = TransaksiItem::whereIn('transaksi_id', $transaksiIds)->get();

        // Total item obat yang terjual
        $totalObatTerjual = $itemsHariIni->sum('jumlah');

        // Obat apa saja yang terjual
        $obatTerjualHariIni = $itemsHariIni->groupBy('obat_id')->map(function ($group) {
            return [
                'nama' => $group->first()->obat->nama,
                'jumlah' => $group->sum('jumlah'),
            ];
        });

        return view('karyawan.dashboard', [
            'totalHariIni' => $totalHariIni,
            'totalObatTerjual' => $totalObatTerjual,
            'obatTerjualHariIni' => $obatTerjualHariIni,
        ]);
    }
}
