<?php

namespace App\Http\Controllers;
use App\Models\Obat;
use Illuminate\Support\Facades\Auth;
use App\Models\Resep;
use Illuminate\Support\Facades\Log;
use App\Models\ResepObat;
use Carbon\Carbon;

use Illuminate\Http\Request;

class DokterController extends Controller
{
   public function dashboard()
{
    $dokterId = Auth::user()->id;

    $totalResep = Resep::where('dokter_id', $dokterId)->count();

    $latestReseps = Resep::where('dokter_id', $dokterId)
        ->latest()
        ->take(5)
        ->get();

    $recentReseps = Resep::where('dokter_id', $dokterId)
        ->latest()
        ->take(5)
        ->get();

    $jumlahResepHariIni = Resep::where('dokter_id', $dokterId)
        ->whereDate('created_at', now())
        ->count();

    $obatDiresepkan = ResepObat::with('obat')
        ->whereHas('resep', function ($q) use ($dokterId) {
            $q->where('dokter_id', $dokterId);
        })->get();

    $obatDiresepkanIds = $obatDiresepkan->pluck('obat_id')->unique();

    $obatBelumDiresepkan = Obat::whereNotIn('id', $obatDiresepkanIds)->get();

    $totalObatBelumDiresepkan = $obatBelumDiresepkan->count();

    return view('dokter.dashboard', compact(
        'latestReseps',
        'jumlahResepHariIni',
        'obatDiresepkan',
        'obatBelumDiresepkan',
        'recentReseps',
        'totalResep',
        'totalObatBelumDiresepkan',
    ))->with('totalObatDiresepkan', $obatDiresepkanIds->count());
}

    public function obatDiresepkan()
    {
        $dokterId = Auth::id();

        $obats = Obat::whereHas('reseps', function ($query) use ($dokterId) {
            $query->where('dokter_id', $dokterId);
        })->with(['reseps' => function ($q) use ($dokterId) {
            $q->where('dokter_id', $dokterId);
        }])->paginate(10);

        return view('dokter.obat.diresepkan', compact('obats'));
    }


    public function obatBelumDiresepkan()
    {
        $dokterId = Auth::id();

        $obats = Obat::whereDoesntHave('reseps', function ($query) use ($dokterId) {
            $query->where('dokter_id', $dokterId);
        })->paginate(10);

        return view('dokter.obat.belum', compact('obats'));
    }

}
