<?php

namespace App\Http\Controllers;

use App\Models\Transaksi;
use Carbon\Carbon;
use Barryvdh\DomPDF\Facade\Pdf;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;

class AdminLaporanController extends Controller
{
    public function cetakHarian()
    {
        $tanggal = Carbon::today();
        return $this->generateLaporan('Harian', $tanggal, $tanggal);
    }

    public function cetakMingguan()
    {
        $start = Carbon::now()->startOfWeek();
        $end = Carbon::now()->endOfWeek();
        return $this->generateLaporan('Mingguan', $start, $end);
    }

    public function cetakBulanan()
    {
        $start = Carbon::now()->startOfMonth();
        $end = Carbon::now()->endOfMonth();
        return $this->generateLaporan('Bulanan', $start, $end);
    }

    private function generateLaporan($judul, $start, $end)
    {
        $data = Transaksi::with('items.obat')
            ->whereBetween('tanggal_transaksi', [$start, $end])
            ->get();

        $total = $data->sum('total');

        return Pdf::loadView('admin.laporan_pdf', [
            'data' => $data,
            'total' => $total,
            'judul' => "Laporan {$judul} (" . $start->format('d M Y') . " - " . $end->format('d M Y') . ")"
        ])->download("laporan_{$judul}_" . now()->format('Ymd_His') . ".pdf");
    }
}
