

<?php $__env->startSection('content'); ?>
<div class="space-y-8">
    <!-- Header -->
    <div class="flex flex-col md:flex-row md:items-center md:justify-between">
        <div>
            <h1 class="text-2xl font-bold text-gray-900 flex items-center">
                <i class="fas fa-house-medical text-indigo-600 mr-3"></i>Dashboard Dokter
            </h1>
            <p class="text-gray-600 mt-2">Ringkasan aktivitas dan statistik resep obat</p>
        </div>
        <div class="mt-4 md:mt-0">
            <span class="bg-indigo-100 text-indigo-800 text-sm font-medium px-3 py-1 rounded-full">
                <i class="far fa-calendar-alt mr-1"></i> 
                <span id="current-date"></span>
            </span>
        </div>
    </div>

    <!-- Statistik Cards -->
    <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
        <!-- Kartu: Total Resep -->
        <div class="bg-white p-6 rounded-xl shadow-md dashboard-card">
            <div class="flex justify-between items-start">
                <div>
                    <h2 class="text-sm font-semibold text-gray-500 uppercase tracking-wider">Total Resep</h2>
                    <p class="text-3xl font-bold text-indigo-600 mt-2"><?php echo e($recentReseps->count()); ?></p>
                </div>
                <div class="bg-indigo-100 p-3 rounded-full">
                    <i class="fas fa-file-prescription text-indigo-600 text-xl"></i>
                </div>
            </div>
            <div class="mt-4">
                <span class="text-xs text-gray-500"><i class="fas fa-info-circle mr-1"></i> Jumlah resep yang dibuat</span>
            </div>
        </div>

        <!-- Kartu: Obat Diresepkan -->
        <div class="bg-white p-6 rounded-xl shadow-md dashboard-card">
            <div class="flex justify-between items-start">
                <div>
                    <h2 class="text-sm font-semibold text-gray-500 uppercase tracking-wider">Obat Diresepkan</h2>
                    <p class="text-3xl font-bold text-green-600 mt-2"><?php echo e($totalObatDiresepkan); ?></p>
                </div>
                <div class="bg-green-100 p-3 rounded-full">
                    <i class="fas fa-pills text-green-600 text-xl"></i>
                </div>
            </div>
            <div class="mt-4">
                <span class="text-xs text-gray-500"><i class="fas fa-info-circle mr-1"></i> Total item obat yang diresepkan</span>
            </div>
        </div>
    </div>

    <!-- Tombol Aksi -->
    <div class="flex flex-wrap gap-4">
        <a href="<?php echo e(route('dokter.reseps.create')); ?>" class="bg-indigo-600 hover:bg-indigo-700 text-white px-5 py-3 rounded-xl shadow-md flex items-center transition">
            <i class="fas fa-plus-circle mr-2"></i> Buat Resep Baru
        </a>
        <a href="<?php echo e(route('dokter.obat.diresepkan')); ?>" class="bg-green-600 hover:bg-green-700 text-white px-5 py-3 rounded-xl shadow-md flex items-center transition">
            <i class="fas fa-list-check mr-2"></i> Lihat Obat Diresepkan
        </a>
    </div>

    <!-- Daftar 5 Resep Terbaru -->
    <div class="bg-white p-6 rounded-xl shadow-md">
        <h2 class="text-lg font-bold text-gray-800 mb-4 flex items-center">
            <i class="fas fa-history text-indigo-600 mr-2"></i> 5 Resep Terbaru
        </h2>
        
        <?php if($recentReseps->count() > 0): ?>
        <div class="overflow-x-auto">
            <table class="w-full text-sm">
                <thead>
                    <tr class="bg-gray-50 text-gray-700">
                        <th class="px-4 py-3 text-left">Kode Resep</th>
                        <th class="px-4 py-3 text-left">Tanggal</th>
                        <th class="px-4 py-3 text-left">Status</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-100">
                    <?php $__currentLoopData = $recentReseps; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $resep): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr class="hover:bg-gray-50 transition">
                        <td class="px-4 py-3 font-medium">#<?php echo e($resep->kode_resep); ?></td>
                        <td class="px-4 py-3"><?php echo e($resep->created_at->format('d M Y')); ?></td>
                        <td class="px-4 py-3">
                            <span class="bg-green-100 text-green-800 text-xs font-medium px-2 py-1 rounded-full">
                                Selesai
                            </span>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
        <?php else: ?>
        <div class="text-center py-8">
            <div class="flex flex-col items-center justify-center text-gray-400">
                <i class="fas fa-file-medical text-4xl mb-3"></i>
                <p>Belum ada resep dibuat.</p>
                <p class="text-sm mt-2">Klik "Buat Resep Baru" untuk membuat resep pertama Anda.</p>
            </div>
        </div>
        <?php endif; ?>
        
        <?php if($recentReseps->count() > 0): ?>
        <div class="mt-4 text-right">
            <a href="<?php echo e(route('dokter.reseps.index')); ?>" class="text-indigo-600 hover:text-indigo-800 text-sm font-medium flex items-center justify-end">
                Lihat semua resep <i class="fas fa-arrow-right ml-1"></i>
            </a>
        </div>
        <?php endif; ?>
    </div>
</div>

<style>
    .dashboard-card {
        transition: all 0.3s ease;
        border-left: 4px solid;
    }
    
    .dashboard-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 10px 25px -5px rgba(0, 0, 0, 0.1);
    }
    
    .dashboard-card:nth-child(1) { border-left-color: #4f46e5; }
    .dashboard-card:nth-child(2) { border-left-color: #10b981; }
    .dashboard-card:nth-child(3) { border-left-color: #f59e0b; }
</style>

<script>
    // Menampilkan tanggal hari ini
    document.addEventListener('DOMContentLoaded', function() {
        const now = new Date();
        const options = { weekday: 'long', year: 'numeric', month: 'long', day: 'numeric' };
        document.getElementById('current-date').textContent = now.toLocaleDateString('id-ID', options);
    });
</script>

<!-- Include Font Awesome -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

<?php $__env->stopSection(); ?>
<?php echo $__env->make('dokter.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\inventory-apotik\resources\views/dokter/dashboard.blade.php ENDPATH**/ ?>