<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Login - Sistem Apotik</title>
  <script src="https://cdn.tailwindcss.com"></script>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  <style>
    @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap');
    
    body {
      font-family: 'Poppins', sans-serif;
      background: linear-gradient(120deg, #3b82f6, #60a5fa);
      background-attachment: fixed;
    }
    
    .login-container {
      transition: all 0.3s ease;
      box-shadow: 0 10px 25px -5px rgba(0, 0, 0, 0.1);
    }
    
    .login-container:hover {
      transform: translateY(-5px);
      box-shadow: 0 20px 30px -10px rgba(0, 0, 0, 0.15);
    }
    
    .input-field {
      transition: all 0.3s;
    }
    
    .input-field:focus {
      box-shadow: 0 0 0 4px rgba(59, 130, 246, 0.2);
    }
    
    .medicine-icon {
      background: linear-gradient(135deg, #3b82f6, #60a5fa);
      box-shadow: 0 4px 6px rgba(59, 130, 246, 0.3);
    }
  </style>
</head>
<body class="flex items-center justify-center min-h-screen p-4">
  <div class="login-container bg-white rounded-xl shadow-md w-full max-w-md overflow-hidden">
    <!-- Header dengan ikon -->
    <div class="flex justify-center -mt-12">
      <div class="medicine-icon w-24 h-24 rounded-full flex items-center justify-center">
        <i class="fas fa-pills text-white text-4xl"></i>
      </div>
    </div>
    
    <div class="px-8 pt-4 pb-8">
      <h1 class="text-3xl font-bold text-center text-gray-800 mt-2 mb-2">Sistem Apotik</h1>
      <p class="text-center text-gray-600 mb-8">Masuk ke akun Anda untuk melanjutkan</p>
      
      <!-- Notifikasi Error -->
      <?php if(session('error')): ?>
        <div class="bg-red-50 text-red-700 px-4 py-3 rounded-lg mb-6 flex items-start">
          <i class="fas fa-exclamation-circle mt-1 mr-3"></i>
          <div><?php echo e(session('error')); ?></div>
        </div>
      <?php endif; ?>
      
      <!-- Form Login -->
      <form method="POST" action="<?php echo e(route('login')); ?>">
        <?php echo csrf_field(); ?>
        
        <!-- Email Field -->
        <div class="mb-5">
          <label class="block text-gray-700 mb-2 font-medium">
            <i class="fas fa-envelope text-blue-500 mr-2"></i>Alamat Email
          </label>
          <div class="relative">
            <input type="email" name="email" class="input-field w-full border border-gray-300 rounded-lg px-4 py-3 pr-10 focus:outline-none focus:border-blue-500" placeholder="nama@contoh.com" required>
            <i class="fas fa-user-circle absolute right-3 top-3.5 text-gray-400"></i>
          </div>
        </div>
        
        <!-- Password Field -->
        <div class="mb-6">
          <label class="block text-gray-700 mb-2 font-medium">
            <i class="fas fa-lock text-blue-500 mr-2"></i>Kata Sandi
          </label>
          <div class="relative">
            <input type="password" name="password" class="input-field w-full border border-gray-300 rounded-lg px-4 py-3 pr-10 focus:outline-none focus:border-blue-500" placeholder="Masukkan kata sandi" required>
            <i class="fas fa-key absolute right-3 top-3.5 text-gray-400"></i>
          </div>
        </div>
                
        <!-- Submit Button -->
        <button type="submit" class="w-full bg-blue-600 hover:bg-blue-700 text-white font-semibold py-3 rounded-lg transition duration-300 flex items-center justify-center">
          <i class="fas fa-sign-in-alt mr-2"></i> Masuk
        </button>
      </form>
      
  <script>
    // Menambahkan efek interaktif pada input fields
    document.querySelectorAll('.input-field').forEach(input => {
      input.addEventListener('focus', () => {
        input.parentElement.querySelector('i').style.color = '#3b82f6';
      });
      
      input.addEventListener('blur', () => {
        input.parentElement.querySelector('i').style.color = '#9ca3af';
      });
    });
  </script>
</body>
</html><?php /**PATH D:\inventory-apotik\resources\views/auth/login.blade.php ENDPATH**/ ?>