

<?php $__env->startSection('content'); ?>
<div class="max-w-6xl mx-auto">
    <div class="bg-white rounded-2xl shadow-lg overflow-hidden border border-gray-100">
        <!-- Header -->
        <div class="bg-gradient-to-r from-indigo-600 to-indigo-700 px-6 py-5 text-white">
            <div class="flex items-center justify-between">
                <div class="flex items-center space-x-3">
                    <div class="bg-white/20 p-2 rounded-lg">
                        <i class="fas fa-prescription-bottle text-xl"></i>
                    </div>
                    <div>
                        <h2 class="text-xl font-bold">Tambah Resep Obat</h2>
                        <p class="text-indigo-100 text-sm">Buat resep untuk pasien dengan mudah</p>
                    </div>
                </div>
                <div class="bg-white/10 px-3 py-1 rounded-full text-xs font-medium">
                    <i class="fas fa-clock mr-1"></i> <?php echo e(now()->format('d M Y')); ?>

                </div>
            </div>
        </div>

        <!-- Form Container -->
        <form action="<?php echo e(route('dokter.reseps.store')); ?>" method="POST" class="px-6 py-5">
            <?php echo csrf_field(); ?>
            <div id="reseps-container" class="space-y-6">
                <!-- Resep pertama -->
                <div class="resep-item bg-gray-50 border border-gray-200 rounded-xl p-5 transition-all duration-300 hover:shadow-md">
                    <div class="flex justify-between items-center mb-5">
                        <div class="flex items-center">
                            <span class="bg-indigo-500 text-white rounded-full w-7 h-7 flex items-center justify-center mr-3">1</span>
                            <h3 class="text-lg font-semibold text-gray-800">Resep Obat</h3>
                        </div>
                        <button type="button" class="remove-resep text-red-500 hover:text-red-700 text-sm font-medium hidden">
                            <i class="fas fa-trash-alt mr-1"></i> Hapus Resep
                        </button>
                    </div>

                    <div class="mb-5">
                        <label class="block text-sm font-medium text-gray-700 mb-2">
                            <i class="fas fa-barcode mr-2 text-indigo-500"></i>Kode Resep
                        </label>
                        <input type="text" name="kode_resep[]" class="w-full px-4 py-2.5 border border-gray-300 rounded-lg shadow-sm focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500 transition" required placeholder="Masukkan kode resep">
                    </div>

                    <div class="obat-container space-y-4">
                        <div class="obat-row bg-white border border-gray-200 rounded-lg p-4 shadow-sm">
                            <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                                <div>
                                    <label class="block text-sm font-medium text-gray-700 mb-2">
                                        <i class="fas fa-pills mr-2 text-indigo-500"></i>Obat
                                    </label>
                                    <select name="obat_id[0][]" class="obat-select w-full px-4 py-2.5 border border-gray-300 rounded-lg focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500 transition" required>
                                        <option value="">Pilih Obat</option>
                                        <?php $__currentLoopData = $obats; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $obat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($obat->id); ?>"
                                                data-dosis="<?php echo e($obat->dosis ?? '3x sehari'); ?>"
                                                data-aturan="<?php echo e($obat->aturan_pakai ?? 'Sebelum makan'); ?>">
                                                <?php echo e($obat->nama); ?>

                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                                <div>
                                    <label class="block text-sm font-medium text-gray-700 mb-2">
                                        <i class="fas fa-syringe mr-2 text-indigo-500"></i>Dosis
                                    </label>
                                    <input type="text" name="dosis[0][]" class="dosis-input w-full px-4 py-2.5 border border-gray-300 rounded-lg focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500 transition" required placeholder="Contoh: 3x sehari">
                                </div>
                                <div>
                                    <label class="block text-sm font-medium text-gray-700 mb-2">
                                        <i class="fas fa-info-circle mr-2 text-indigo-500"></i>Aturan Pakai
                                    </label>
                                    <input type="text" name="aturan_pakai[0][]" class="aturan-input w-full px-4 py-2.5 border border-gray-300 rounded-lg focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500 transition" required placeholder="Contoh: Sebelum makan">
                                </div>
                            </div>
                            <div class="flex justify-end mt-3">
                                <button type="button" class="remove-obat text-red-500 hover:text-red-700 text-sm font-medium">
                                    <i class="fas fa-times mr-1"></i> Hapus Obat
                                </button>
                            </div>
                        </div>
                    </div>

                    <div class="mt-5">
                        <button type="button" class="add-obat bg-indigo-50 text-indigo-600 hover:bg-indigo-100 px-4 py-2 rounded-lg text-sm font-medium transition">
                            <i class="fas fa-plus-circle mr-2"></i> Tambah Obat
                        </button>
                    </div>
                </div>
            </div>

            <div class="mt-8 flex flex-col sm:flex-row gap-3">
                <button type="button" id="add-resep" class="bg-indigo-50 text-indigo-600 hover:bg-indigo-100 px-4 py-2.5 rounded-lg text-sm font-medium transition flex items-center justify-center">
                    <i class="fas fa-plus-circle mr-2"></i> Tambah Resep Baru
                </button>
                <button type="submit" class="bg-indigo-600 text-white hover:bg-indigo-700 px-6 py-2.5 rounded-lg text-sm font-semibold transition flex items-center justify-center">
                    <i class="fas fa-save mr-2"></i> Simpan Semua Resep
                </button>
            </div>
        </form>
    </div>
</div>

<script>
    let resepIndex = 1;

    // Tambah resep baru
    document.getElementById('add-resep').addEventListener('click', function () {
        const container = document.getElementById('reseps-container');
        const firstResep = container.querySelector('.resep-item');
        const newResep = firstResep.cloneNode(true);

        resepIndex++;

        // Reset input
        newResep.querySelector('input[name="kode_resep[]"]').value = '';
        newResep.querySelectorAll('input').forEach(input => input.value = '');
        newResep.querySelectorAll('select').forEach(select => select.selectedIndex = 0);

        // Update name attribute sesuai index
        newResep.querySelectorAll('.obat-select').forEach((select, i) => {
            select.name = `obat_id[${resepIndex}][]`;
        });
        newResep.querySelectorAll('.dosis-input').forEach(input => {
            input.name = `dosis[${resepIndex}][]`;
        });
        newResep.querySelectorAll('.aturan-input').forEach(input => {
            input.name = `aturan_pakai[${resepIndex}][]`;
        });

        // Show tombol hapus resep
        newResep.querySelector('.remove-resep').classList.remove('hidden');

        // Update nomor resep
        const numberSpan = newResep.querySelector('.bg-indigo-500');
        numberSpan.textContent = resepIndex;
        
        // Update judul
        const title = newResep.querySelector('h3');
        title.textContent = `Resep Obat`;

        container.appendChild(newResep);
        
        // Inisialisasi event listener untuk select obat
        initObatSelectListeners();
    });

    // Hapus resep
    document.addEventListener('click', function (e) {
        if (e.target.classList.contains('remove-resep') || e.target.closest('.remove-resep')) {
            const resepItems = document.querySelectorAll('.resep-item');
            if (resepItems.length > 1) {
                const itemToRemove = e.target.closest('.resep-item');
                itemToRemove.classList.add('opacity-0');
                setTimeout(() => {
                    itemToRemove.remove();
                    // Update nomor resep yang tersisa
                    document.querySelectorAll('.resep-item').forEach((item, index) => {
                        const numberSpan = item.querySelector('.bg-indigo-500');
                        numberSpan.textContent = index + 1;
                    });
                }, 300);
            }
        }

        if (e.target.classList.contains('remove-obat') || e.target.closest('.remove-obat')) {
            const obatRows = e.target.closest('.obat-container').querySelectorAll('.obat-row');
            if (obatRows.length > 1) {
                const rowToRemove = e.target.closest('.obat-row');
                rowToRemove.classList.add('opacity-0', 'transform', '-translate-x-4');
                setTimeout(() => {
                    rowToRemove.remove();
                }, 300);
            }
        }
    });

    // Tambah obat dalam resep
    document.addEventListener('click', function (e) {
        if (e.target.classList.contains('add-obat') || e.target.closest('.add-obat')) {
            const resepDiv = e.target.closest('.resep-item');
            const container = resepDiv.querySelector('.obat-container');
            const firstRow = container.querySelector('.obat-row');
            const newRow = firstRow.cloneNode(true);

            // Reset isi form
            newRow.querySelectorAll('input').forEach(input => input.value = '');
            newRow.querySelector('select').selectedIndex = 0;

            // Sembunyikan dulu kemudian tampilkan dengan animasi
            newRow.classList.add('opacity-0', 'transform', 'translate-x-4');
            container.appendChild(newRow);
            
            // Trigger reflow untuk memastikan animasi berjalan
            void newRow.offsetWidth;
            
            // Animasi masuk
            newRow.classList.remove('opacity-0', 'transform', 'translate-x-4');
            
            // Inisialisasi event listener untuk select obat
            initObatSelectListeners();
        }
    });

    // Fungsi untuk inisialisasi event listener pada select obat
    function initObatSelectListeners() {
        document.querySelectorAll('.obat-select').forEach(select => {
            select.addEventListener('change', function() {
                const selectedOption = this.options[this.selectedIndex];
                const dosis = selectedOption.getAttribute('data-dosis');
                const aturan = selectedOption.getAttribute('data-aturan');
                
                if (dosis) {
                    this.closest('.obat-row').querySelector('.dosis-input').value = dosis;
                }
                if (aturan) {
                    this.closest('.obat-row').querySelector('.aturan-input').value = aturan;
                }
            });
        });
    }

    // Inisialisasi saat halaman dimuat
    document.addEventListener('DOMContentLoaded', function() {
        initObatSelectListeners();
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('dokter.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\inventory-apotik\resources\views/dokter/reseps/create.blade.php ENDPATH**/ ?>