

<?php $__env->startSection('content'); ?>
<div class="mb-6">
    <h1 class="text-2xl font-bold mb-2">Data Obat</h1>
</div>

<?php if(session('success')): ?>
    <div class="bg-green-100 text-green-700 px-4 py-2 rounded mb-4">
        <?php echo e(session('success')); ?>

    </div>
<?php endif; ?>


<div class="mb-6">
    <label for="obat-search" class="block text-sm font-semibold text-gray-700 mb-2">
        🔍 Cari Nama Obat
    </label>
    <div class="flex flex-col sm:flex-row items-center gap-2">
        <select id="obat-search" class="w-full sm:w-80 border border-gray-300 rounded-lg shadow-sm">
            <option value="">Ketik nama obat...</option>
        </select>
        
        <?php if(request('obat_id')): ?>
            <a href="<?php echo e(route('admin.obats.index')); ?>"
               class="text-sm text-red-600 hover:underline whitespace-nowrap">
               🔄 Reset
            </a>
        <?php endif; ?>
    </div>
</div>

<div class="overflow-x-auto">
    <table class="w-full border border-gray-200 rounded-lg">
        <thead class="bg-gray-100">
            <tr class="text-left">
                <th class="p-2">No</th>
                <th class="p-2">Nama Obat</th>
                <th class="p-2">Kategori</th>
                <th class="p-2">Satuan</th>
                <th class="p-2">Stok</th>
                <th class="p-2">Harga</th>
                <th class="p-2">Expired</th>
                <th class="p-2">Supplier Terakhir</th>
                <th class="p-2">Aksi</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $obats; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $obat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr class="border-t">
                <td class="p-2"><?php echo e($loop->iteration); ?></td>
                <td class="p-2"><?php echo e($obat->nama); ?></td>
                <td class="p-2"><?php echo e($obat->kategori->nama ?? '-'); ?></td>
                <td class="p-2"><?php echo e($obat->satuan); ?></td>
                <td class="p-2"><?php echo e($obat->stok); ?></td>
                <td class="p-2">Rp<?php echo e(number_format($obat->harga, 0, ',', '.')); ?></td>
                <td class="p-2"><?php echo e($obat->expired_at); ?></td>
                <td class="p-2"><?php echo e($obat->supplier_terakhir); ?></td>
                <td class="p-2 flex gap-2">
                    <a href="<?php echo e(route('admin.obats.edit', $obat->id)); ?>" class="text-blue-600 hover:underline">Edit</a>
                    <form action="<?php echo e(route('admin.obats.destroy', $obat->id)); ?>" method="POST" onsubmit="return confirm('Yakin ingin hapus?')">
                        <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                        <button class="text-red-600 hover:underline">Hapus</button>
                    </form>
                </td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
</div>


<div class="mt-4">
    <?php echo e($obats->links()); ?>

</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

<script>
$(document).ready(function () {
    $('#obat-search').select2({
        placeholder: 'Ketik nama obat...',
        allowClear: true,
        minimumInputLength: 1,
        width: 'resolve',
        ajax: {
            url: '<?php echo e(route("ajax.obats.search")); ?>',
            dataType: 'json',
            delay: 250,
            data: function (params) {
                return { q: params.term };
            },
            processResults: function (data) {
                return {
                    results: data.map(function (item) {
                        return {
                            id: item.id,
                            text: item.nama
                        };
                    })
                };
            },
            cache: true
        }
    });

    $('#obat-search').on('select2:select', function (e) {
        const id = e.params.data.id;
        window.location.href = `?obat_id=${id}`;
    });
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\inventory-apotik\resources\views/admin/obat/index.blade.php ENDPATH**/ ?>