

<?php $__env->startSection('content'); ?>
<div class="flex justify-between items-center mb-6">
    <h1 class="text-3xl font-bold text-gray-800">📦 Data Obat</h1>
    <a href="<?php echo e(route('admin.master_obat.create')); ?>" 
       class="bg-blue-600 hover:bg-blue-700 text-white px-5 py-2 rounded-lg shadow-md transition">
       + Tambah Obat
    </a>
</div>

<div class="bg-white rounded-lg shadow overflow-hidden">
    <table class="min-w-full">
        <thead class="bg-gray-100 border-b">
            <tr>
                <th class="px-6 py-3 text-left text-sm font-semibold text-gray-700">No</th>
                <th class="px-6 py-3 text-left text-sm font-semibold text-gray-700">Nama Obat</th>
                <th class="px-6 py-3 text-left text-sm font-semibold text-gray-700">Kategori</th>
                <th class="px-6 py-3 text-center text-sm font-semibold text-gray-700">Aksi</th>
            </tr>
        </thead>
        <tbody>
            <?php $__empty_1 = true; $__currentLoopData = $obats; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $obat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <tr class="hover:bg-gray-50 transition">
                <td class="px-6 py-4 text-sm text-gray-800"><?php echo e($loop->iteration); ?></td>
                <td class="px-6 py-4 text-sm text-gray-800"><?php echo e($obat->nama); ?></td>
                <td class="px-6 py-4 text-sm text-gray-800"><?php echo e($obat->kategori->nama); ?></td>
                <td class="px-6 py-4 text-center">
                    <a href="<?php echo e(route('admin.master_obat.edit', $obat->id)); ?>"
                       class="inline-block bg-yellow-400 hover:bg-yellow-500 text-white px-3 py-1 rounded-md text-sm shadow">
                       ✏ Edit
                    </a>
                    <form action="<?php echo e(route('admin.master_obat.destroy', $obat->id)); ?>" method="POST" class="inline-block"
                          onsubmit="return confirm('Yakin ingin menghapus obat ini?');">
                        <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                        <button type="submit"
                                class="bg-red-500 hover:bg-red-600 text-white px-3 py-1 rounded-md text-sm shadow ml-2">
                            🗑 Hapus
                        </button>
                    </form>
                </td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <tr>
                <td colspan="4" class="px-6 py-4 text-center text-gray-500 text-sm">Belum ada data obat</td>
            </tr>
            <?php endif; ?>
        </tbody>
    </table>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\inventory-apotik\resources\views/admin/master_obat/index.blade.php ENDPATH**/ ?>