

<?php $__env->startSection('content'); ?>
<div class="max-w-7xl mx-auto px-4 py-6">
    <!-- Header -->
    <div class="flex flex-col md:flex-row md:items-center justify-between mb-8">
        <div>
            <h1 class="text-3xl font-bold text-gray-900">
                <i class="fas fa-clinic-medical text-blue-500 mr-3"></i>Dashboard Admin Apotik
            </h1>
            <p class="text-gray-600 mt-2">Selamat datang, Admin! Berikut ringkasan aktivitas sistem.</p>
        </div>
        <div class="mt-4 md:mt-0">
            <span class="bg-blue-100 text-blue-800 text-sm font-medium px-3 py-1 rounded-full">
                <i class="far fa-calendar-alt mr-1"></i> 
                <span id="current-date"></span>
            </span>
        </div>
    </div>

    <!-- Statistik Ringkas -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-5 mb-8">
        <a href="<?php echo e(route('admin.master_obat.index')); ?>" class="dashboard-card bg-white p-5 shadow-sm stat-card total-obat">
            <div class="flex justify-between items-start">
                <div>
                    <h2 class="text-sm font-semibold text-gray-500 uppercase tracking-wider">Total Obat</h2>
                    <p class="text-3xl font-bold text-blue-600 mt-2"><?php echo e($totalObat); ?></p>
                </div>
                <div class="bg-blue-100 p-3 rounded-full">
                    <i class="fas fa-pills text-blue-600 text-xl"></i>
                </div>
            </div>
            <div class="mt-4">
                <span class="text-xs text-gray-500"><i class="fas fa-info-circle mr-1"></i> Klik untuk melihat detail</span>
            </div>
        </a>

        <a href="<?php echo e(route('admin.master_obat.stok_menipis')); ?>" class="dashboard-card bg-white p-5 shadow-sm stat-card stok-menipis">
            <div class="flex justify-between items-start">
                <div>
                    <h2 class="text-sm font-semibold text-gray-500 uppercase tracking-wider">Stok Menipis</h2>
                    <p class="text-3xl font-bold text-yellow-600 mt-2"><?php echo e($stokMenipis); ?></p>
                </div>
                <div class="bg-yellow-100 p-3 rounded-full">
                    <i class="fas fa-exclamation-triangle text-yellow-600 text-xl"></i>
                </div>
            </div>
            <div class="mt-4">
                <span class="text-xs text-gray-500"><i class="fas fa-info-circle mr-1"></i> Perlu restock segera</span>
            </div>
        </a>

        <a href="<?php echo e(route('admin.master_obat.kadaluarsa')); ?>" class="dashboard-card bg-white p-5 shadow-sm stat-card kadaluarsa">
            <div class="flex justify-between items-start">
                <div>
                    <h2 class="text-sm font-semibold text-gray-500 uppercase tracking-wider">Kadaluarsa</h2>
                    <p class="text-3xl font-bold text-red-600 mt-2"><?php echo e($kadaluarsa); ?></p>
                </div>
                <div class="bg-red-100 p-3 rounded-full">
                    <i class="fas fa-skull-crossbones text-red-600 text-xl"></i>
                </div>
            </div>
            <div class="mt-4">
                <span class="text-xs text-gray-500"><i class="fas fa-info-circle mr-1"></i> Perlu penanganan khusus</span>
            </div>
        </a>

        <a href="<?php echo e(route('admin.suppliers.index')); ?>" class="dashboard-card bg-white p-5 shadow-sm stat-card total-supplier">
            <div class="flex justify-between items-start">
                <div>
                    <h2 class="text-sm font-semibold text-gray-500 uppercase tracking-wider">Total Supplier</h2>
                    <p class="text-3xl font-bold text-green-600 mt-2"><?php echo e($totalSupplier); ?></p>
                </div>
                <div class="bg-green-100 p-3 rounded-full">
                    <i class="fas fa-truck-loading text-green-600 text-xl"></i>
                </div>
            </div>
            <div class="mt-4">
                <span class="text-xs text-gray-500"><i class="fas fa-info-circle mr-1"></i> Partner penyedia obat</span>
            </div>
        </a>
    </div>

    <!-- Tombol Cetak Laporan -->
    <div class="bg-white p-5 rounded-xl shadow-sm mb-8">
        <h2 class="text-lg font-bold text-gray-700 mb-4 flex items-center">
            <i class="fas fa-file-export text-blue-500 mr-2"></i> Ekspor Laporan
        </h2>
        <div class="flex flex-wrap gap-3">
            <a href="<?php echo e(route('admin.laporan.harian.pdf')); ?>" class="btn bg-blue-100 text-blue-700 px-4 py-2.5 rounded-lg hover:bg-blue-200 text-sm font-medium flex items-center">
                <i class="fas fa-file-pdf mr-2"></i> Cetak Harian
            </a>
            <a href="<?php echo e(route('admin.laporan.mingguan.pdf')); ?>" class="btn bg-yellow-100 text-yellow-700 px-4 py-2.5 rounded-lg hover:bg-yellow-200 text-sm font-medium flex items-center">
                <i class="fas fa-file-pdf mr-2"></i> Cetak Mingguan
            </a>
            <a href="<?php echo e(route('admin.laporan.bulanan.pdf')); ?>" class="btn bg-green-100 text-green-700 px-4 py-2.5 rounded-lg hover:bg-green-200 text-sm font-medium flex items-center">
                <i class="fas fa-file-pdf mr-2"></i> Cetak Bulanan
            </a>
        </div>
    </div>

    <!-- Grafik dan Statistik -->
    <div class="grid grid-cols-1 lg:grid-cols-2 gap-6 mb-8">
        <!-- Grafik Stok Obat -->
        <div class="bg-white p-5 rounded-xl shadow-sm">
            <h2 class="text-lg font-bold text-gray-700 mb-4 flex items-center">
                <i class="fas fa-chart-bar text-blue-500 mr-2"></i> Grafik Stok Obat
            </h2>
            <canvas id="obatChart" height="250"></canvas>
        </div>

        <!-- Statistik Transaksi Hari Ini -->
        <div>
            <div class="bg-white p-5 rounded-xl shadow-sm mb-6">
                <h2 class="text-lg font-bold text-gray-700 mb-4 flex items-center">
                    <i class="fas fa-shopping-cart text-green-500 mr-2"></i> Transaksi Hari Ini
                </h2>
                <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                    <div class="bg-blue-50 p-4 rounded-lg text-center">
                        <div class="bg-blue-100 inline-flex rounded-full p-3 mb-2">
                            <i class="fas fa-money-bill-wave text-blue-600 text-xl"></i>
                        </div>
                        <h3 class="text-sm font-semibold text-gray-600">Omzet Hari Ini</h3>
                        <p class="text-xl font-bold text-blue-600 mt-1">Rp <?php echo e(number_format($omzetHariIni, 0, ',', '.')); ?></p>
                    </div>
                    <div class="bg-indigo-50 p-4 rounded-lg text-center">
                        <div class="bg-indigo-100 inline-flex rounded-full p-3 mb-2">
                            <i class="fas fa-pills text-indigo-600 text-xl"></i>
                        </div>
                        <h3 class="text-sm font-semibold text-gray-600">Total Obat Terjual</h3>
                        <p class="text-xl font-bold text-indigo-600 mt-1"><?php echo e($totalObatTerjual); ?> item</p>
                    </div>
                    <div class="bg-amber-50 p-4 rounded-lg text-center">
                        <div class="bg-amber-100 inline-flex rounded-full p-3 mb-2">
                            <i class="fas fa-boxes text-amber-600 text-xl"></i>
                        </div>
                        <h3 class="text-sm font-semibold text-gray-600">Jenis Obat Terjual</h3>
                        <p class="text-xl font-bold text-amber-600 mt-1"><?php echo e($jenisObatTerjual); ?> jenis</p>
                    </div>
                </div>
            </div>

            <!-- Detail Obat Terjual -->
            <div class="bg-white p-5 rounded-xl shadow-sm">
                <h2 class="text-lg font-bold text-gray-700 mb-4 flex items-center">
                    <i class="fas fa-list-alt text-purple-500 mr-2"></i> Detail Obat Terjual
                </h2>
                <div class="overflow-x-auto">
                    <table class="w-full text-sm">
                        <thead>
                            <tr class="bg-gray-100 text-gray-600">
                                <th class="px-4 py-2 text-left">Nama Obat</th>
                                <th class="px-4 py-2 text-left">Jumlah</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $detailObat; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr class="border-b border-gray-100">
                                    <td class="px-4 py-3"><?php echo e($item->obat ? $item->obat->nama : 'Obat tidak ditemukan'); ?></td>
                                    <td class="px-4 py-3">
                                        <span class="bg-blue-100 text-blue-800 text-xs font-medium px-2 py-0.5 rounded-full">
                                            <?php echo e($item->total); ?> item
                                        </span>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="2" class="px-4 py-3 text-center text-gray-500">
                                        <i class="fas fa-inbox mr-1"></i> Belum ada penjualan hari ini
                                    </td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <!-- Grafik Penjualan Bulanan -->
    <div class="bg-white p-5 rounded-xl shadow-sm mb-8">
        <h2 class="text-lg font-bold text-gray-700 mb-4 flex items-center">
            <i class="fas fa-chart-line text-green-500 mr-2"></i> Penjualan Bulanan
        </h2>
        <canvas id="penjualanChart" height="100"></canvas>
    </div>

    <!-- Peringatan Obat -->
    <div class="grid grid-cols-1 lg:grid-cols-2 gap-6 mb-8">
        <!-- Obat Kadaluarsa -->
        <div class="bg-white p-5 rounded-xl shadow-sm">
            <h2 class="text-lg font-bold text-red-600 mb-4 flex items-center">
                <i class="fas fa-exclamation-circle mr-2"></i> Obat Kadaluarsa
            </h2>
            <div class="overflow-x-auto">
                <table class="w-full text-sm">
                    <thead>
                        <tr class="bg-red-100 text-red-800">
                            <th class="px-4 py-2 text-left">Nama Obat</th>
                            <th class="px-4 py-2 text-left">Kadaluarsa</th>
                            <th class="px-4 py-2 text-left">Stok</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $obatKadaluarsa; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $obat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr class="border-b border-gray-100">
                                <td class="px-4 py-3"><?php echo e($obat->nama); ?></td>
                                <td class="px-4 py-3">
                                    <span class="bg-red-100 text-red-800 text-xs font-medium px-2 py-0.5 rounded-full">
                                        <?php echo e(\Carbon\Carbon::parse($obat->expired_at)->format('d-m-Y')); ?>

                                    </span>
                                </td>
                                <td class="px-4 py-3"><?php echo e($obat->stok); ?></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="3" class="px-4 py-3 text-center text-gray-500">
                                    <i class="fas fa-check-circle mr-1"></i> Tidak ada obat kadaluarsa
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>

        <!-- Obat Stok Menipis -->
        <div class="bg-white p-5 rounded-xl shadow-sm">
            <h2 class="text-lg font-bold text-yellow-600 mb-4 flex items-center">
                <i class="fas fa-exclamation-triangle mr-2"></i> Obat Stok Menipis
            </h2>
            <div class="overflow-x-auto">
                <table class="w-full text-sm">
                    <thead>
                        <tr class="bg-yellow-100 text-yellow-800">
                            <th class="px-4 py-2 text-left">Nama Obat</th>
                            <th class="px-4 py-2 text-left">Stok</th>
                            <th class="px-4 py-2 text-left">Kadaluarsa</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $obatStokMenipis; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $obat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr class="border-b border-gray-100">
                                <td class="px-4 py-3"><?php echo e($obat->nama); ?></td>
                                <td class="px-4 py-3">
                                    <span class="bg-yellow-100 text-yellow-800 text-xs font-medium px-2 py-0.5 rounded-full">
                                        <?php echo e($obat->stok); ?> item
                                    </span>
                                </td>
                                <td class="px-4 py-3"><?php echo e(\Carbon\Carbon::parse($obat->expired_at)->format('d-m-Y')); ?></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="3" class="px-4 py-3 text-center text-gray-500">
                                    <i class="fas fa-check-circle mr-1"></i> Stok semua obat aman
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<!-- Styles -->
<style>
    .dashboard-card {
        transition: all 0.3s ease;
        border-radius: 12px;
        overflow: hidden;
    }
    
    .dashboard-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 10px 25px -5px rgba(0, 0, 0, 0.1);
    }
    
    .stat-card {
        border-left: 4px solid;
    }
    
    .stat-card.total-obat { border-left-color: #3b82f6; }
    .stat-card.stok-menipis { border-left-color: #f59e0b; }
    .stat-card.kadaluarsa { border-left-color: #ef4444; }
    .stat-card.total-supplier { border-left-color: #10b981; }
    
    .btn {
        transition: all 0.2s ease;
    }
    
    .btn:hover {
        transform: translateY(-2px);
    }
    
    table {
        border-collapse: separate;
        border-spacing: 0;
    }
    
    th {
        background-color: #f8fafc;
    }
    
    tr:nth-child(even) {
        background-color: #f8fafc;
    }
</style>

<!-- Scripts -->
<script>
    // Menampilkan tanggal hari ini
    const now = new Date();
    const options = { weekday: 'long', year: 'numeric', month: 'long', day: 'numeric' };
    document.getElementById('current-date').textContent = now.toLocaleDateString('id-ID', options);
    
    // Grafik Stok Obat
    const ctx = document.getElementById('obatChart').getContext('2d');
    const obatChart = new Chart(ctx, {
        type: 'bar',
        data: {
            labels: <?php echo json_encode($topObats->pluck('nama'), 15, 512) ?>,
            datasets: [{
                label: 'Stok Obat',
                data: <?php echo json_encode($topObats->pluck('total'), 15, 512) ?>,
                backgroundColor: 'rgba(59, 130, 246, 0.7)',
                borderColor: 'rgba(59, 130, 246, 1)',
                borderWidth: 1
            }]
        },
        options: {
            responsive: true,
            plugins: {
                legend: {
                    display: false
                }
            },
            scales: {
                y: {
                    beginAtZero: true,
                    ticks: {
                        stepSize: 1
                    }
                }
            }
        }
    });

    // Grafik Penjualan Bulanan
    const penjualanCtx = document.getElementById('penjualanChart').getContext('2d');
    const penjualanChart = new Chart(penjualanCtx, {
        type: 'line',
        data: {
            labels: <?php echo json_encode($penjualanBulanan->pluck('tanggal')->map(fn($d) => \Carbon\Carbon::parse($d)->format('d M')), 15, 512) ?>,
            datasets: [{
                label: 'Penjualan (Rp)',
                data: <?php echo json_encode($penjualanBulanan->pluck('total'), 15, 512) ?>,
                backgroundColor: 'rgba(34, 197, 94, 0.2)',
                borderColor: 'rgba(34, 197, 94, 1)',
                borderWidth: 2,
                tension: 0.3,
                fill: true
            }]
        },
        options: {
            responsive: true,
            scales: {
                y: {
                    beginAtZero: true
                }
            }
        }
    });
</script>

<!-- Include Font Awesome -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\inventory-apotik\resources\views/admin/dashboard.blade.php ENDPATH**/ ?>