<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Rekam Medik</title>
    <style>
        body { font-family: DejaVu Sans, sans-serif; font-size: 12px; }
        h2, h3 { margin: 5px 0; }
        table { width: 100%; border-collapse: collapse; margin-top: 15px; }
        th, td { border: 1px solid #000; padding: 5px; text-align: left; }
    </style>
</head>
<body>
    <h2 style="text-align:center;">Rekam Medik Pasien</h2>

    
    <p><strong>Tanggal:</strong> <?php echo e($transaksi->tanggal_transaksi->format('d/m/Y H:i')); ?></p>
    <p><strong>Pasien:</strong> <?php echo e($transaksi->rekamMedik->nama_pasien); ?></p>
    <p><strong>Dokter:</strong> <?php echo e($transaksi->rekamMedik->resep->dokter->name ?? '-'); ?></p>

    
    <p><strong>Keluhan:</strong><br>
        <?php echo e($transaksi->rekamMedik->keluhan ?? '-'); ?>

    </p>
    <p><strong>Penanganan / Diagnosa:</strong><br>
        <?php echo e($transaksi->rekamMedik->penanganan ?? '-'); ?>

    </p>

    
    <h3>Resep Obat</h3>
    <table>
        <thead>
            <tr>
                <th>Nama Obat</th>
                <th>Dosis</th>
                <th>Aturan Pakai</th>
                <th>Satuan</th>
                <th>Jumlah</th>
                <th>Harga</th>
                <th>Subtotal</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $transaksi->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($item->nama_obat); ?></td>
                <td><?php echo e($item->obat->pivot->dosis ?? '-'); ?></td>
                <td><?php echo e($item->obat->pivot->aturan_pakai ?? '-'); ?></td>
                <td><?php echo e($item->satuan); ?></td>
                <td><?php echo e($item->jumlah); ?></td>
                <td>Rp. <?php echo e(number_format($item->harga_satuan, 0, ',', '.')); ?></td>
                <td>Rp. <?php echo e(number_format($item->subtotal, 0, ',', '.')); ?></td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>

    
    <h3 style="text-align:right; margin-top:10px;">
        Total: Rp. <?php echo e(number_format($transaksi->total, 0, ',', '.')); ?>

    </h3>

    <p style="margin-top:40px; text-align:right;">
        <em>Dokter: <?php echo e($transaksi->rekamMedik->resep->dokter->name ?? '-'); ?></em>
    </p>
</body>
</html>
<?php /**PATH D:\inventory-apotik\resources\views/karyawan/transaksi/pdf_rekam_medik.blade.php ENDPATH**/ ?>