<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard Admin - Sistem Apotik</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://unpkg.com/lucide@latest"></script>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap');
        
        :root {
            --primary: #3b82f6;
            --primary-dark: #2563eb;
            --secondary: #10b981;
            --warning: #f59e0b;
            --danger: #ef4444;
            --light-bg: #f8fafc;
        }
        
        body {
            font-family: 'Poppins', sans-serif;
            background-color: #f1f5f9;
        }
        
        .sidebar {
            background: linear-gradient(to bottom, #3b82f6, #2563eb);
            box-shadow: 0 0 20px rgba(0, 0, 0, 0.1);
            transition: all 0.3s ease;
        }
        
        .nav-item {
            transition: all 0.2s ease;
            border-radius: 8px;
        }
        
        .nav-item:hover {
            background-color: rgba(255, 255, 255, 0.1);
            transform: translateX(5px);
        }
        
        .nav-item.active {
            background-color: rgba(255, 255, 255, 0.15);
            font-weight: 500;
        }
        
        .submenu {
            transition: all 0.3s ease;
        }
        
        .main-content {
            transition: margin-left 0.3s ease;
        }
        
        .top-navbar {
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
            backdrop-filter: blur(10px);
        }
        
        @media (max-width: 768px) {
            .sidebar {
                transform: translateX(-100%);
                z-index: 50;
            }
            
            .sidebar.open {
                transform: translateX(0);
            }
            
            .main-content {
                margin-left: 0 !important;
            }
            
            .overlay {
                display: none;
                position: fixed;
                top: 0;
                left: 0;
                right: 0;
                bottom: 0;
                background-color: rgba(0, 0, 0, 0.5);
                z-index: 40;
            }
            
            .overlay.open {
                display: block;
            }
        }
    </style>
</head>
<body class="bg-gray-50 flex">
    <!-- Mobile menu button -->
    <div class="md:hidden fixed top-4 left-4 z-50">
        <button id="menuToggle" class="p-2 rounded-md bg-blue-600 text-white shadow-lg">
            <i data-lucide="menu" class="w-5 h-5"></i>
        </button>
    </div>

    <!-- Overlay for mobile -->
    <div id="overlay" class="overlay" onclick="closeSidebar()"></div>

    <!-- Sidebar -->
    <aside id="sidebar" class="sidebar w-64 h-screen text-white px-6 py-4 fixed">
        <div class="flex items-center gap-3 mb-8 pt-4">
            <div class="bg-white p-2 rounded-full">
                <i data-lucide="heart-pulse" class="text-blue-600 w-6 h-6"></i>
            </div>
            <h2 class="text-xl font-bold">Apotik Sehat</h2>
        </div>

        <nav class="space-y-2">
            <a href="<?php echo e(route('admin.dashboard')); ?>" class="nav-item flex items-center gap-3 py-3 px-4 rounded-lg <?php echo e(request()->routeIs('admin.dashboard') ? 'active' : ''); ?>">
                <i data-lucide="home" class="w-5 h-5"></i>
                <span>Dashboard</span>
            </a>

            <a href="<?php echo e(route('admin.kategoris.index')); ?>" class="nav-item flex items-center gap-3 py-3 px-4 rounded-lg <?php echo e(request()->routeIs('admin.kategoris.*') ? 'active' : ''); ?>">
                <i data-lucide="layers" class="w-5 h-5"></i>
                <span>Kategori Obat</span>
            </a>

            <a href="<?php echo e(route('admin.master_obat.index')); ?>" class="nav-item flex items-center gap-3 py-3 px-4 rounded-lg <?php echo e(request()->routeIs('admin.master_obat.index') ? 'active' : ''); ?>">
                <i data-lucide="pill" class="w-5 h-5"></i>
                <span>Master Obat</span>
            </a>

            <div x-data="{ open: <?php echo e(request()->routeIs('admin.pembelian.*') || request()->routeIs('admin.master_obat.kadaluarsa') || request()->routeIs('admin.master_obat.stok_menipis') ? 'true' : 'false'); ?> }">
                <button @click="open = !open" class="nav-item flex items-center justify-between w-full gap-3 py-3 px-4 rounded-lg">
                    <span class="flex items-center gap-3">
                        <i data-lucide="package" class="w-5 h-5"></i>
                        <span>Data Obat</span>
                    </span>
                    <svg :class="{ 'rotate-180': open }" class="w-4 h-4 transition-transform" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M19 9l-7 7-7-7" />
                    </svg>
                </button>
                <div x-show="open" class="submenu ml-6 mt-2 space-y-2" x-cloak>
                    <a href="<?php echo e(route('admin.pembelian.index')); ?>" class="block text-sm py-2 px-4 rounded-lg hover:bg-blue-500 transition <?php echo e(request()->routeIs('admin.pembelian.index') ? 'bg-blue-500' : ''); ?>">
                        <i data-lucide="list" class="w-4 h-4 inline mr-2"></i> Semua Obat
                    </a>
                    <a href="<?php echo e(route('admin.master_obat.kadaluarsa')); ?>" class="block text-sm py-2 px-4 rounded-lg hover:bg-red-500 transition <?php echo e(request()->routeIs('admin.master_obat.kadaluarsa') ? 'bg-red-500' : ''); ?>">
                        <i data-lucide="alert-circle" class="w-4 h-4 inline mr-2"></i> Obat Kadaluarsa
                    </a>
                    <a href="<?php echo e(route('admin.master_obat.stok_menipis')); ?>" class="block text-sm py-2 px-4 rounded-lg hover:bg-yellow-500 transition <?php echo e(request()->routeIs('admin.master_obat.stok_menipis') ? 'bg-yellow-500' : ''); ?>">
                        <i data-lucide="alert-triangle" class="w-4 h-4 inline mr-2"></i> Stok Menipis
                    </a>
                </div>
            </div>

            <a href="<?php echo e(route('admin.suppliers.index')); ?>" class="nav-item flex items-center gap-3 py-3 px-4 rounded-lg <?php echo e(request()->routeIs('admin.suppliers.*') ? 'active' : ''); ?>">
                <i data-lucide="truck" class="w-5 h-5"></i>
                <span>Supplier</span>
            </a>

            <a href="<?php echo e(route('admin.users.index')); ?>" class="nav-item flex items-center gap-3 py-3 px-4 rounded-lg <?php echo e(request()->routeIs('admin.users.*') ? 'active' : ''); ?>">
                <i data-lucide="users" class="w-5 h-5"></i>
                <span>Manajemen User</span>
            </a>

            <a href="<?php echo e(route('admin.pembelian.create')); ?>" class="nav-item flex items-center gap-3 py-3 px-4 rounded-lg <?php echo e(request()->routeIs('admin.pembelian.create') ? 'active' : ''); ?>">
                <i data-lucide="shopping-cart" class="w-5 h-5"></i>
                <span>Pembelian</span>
            </a>

            <button onclick="showLogoutModal()" class="nav-item flex items-center gap-3 py-3 px-4 rounded-lg hover:bg-red-500 w-full text-left mt-10">
                <i data-lucide="log-out" class="w-5 h-5"></i>
                <span>Logout</span>
            </button>
        </nav>

        <div class="absolute bottom-4 left-0 right-0 px-6">
            <div class="text-center text-xs text-blue-100 opacity-75">
                v1.0.0 &copy; <?php echo e(date('Y')); ?> Apotik Sehat
            </div>
        </div>
    </aside>

    <!-- Main Content -->
    <div class="main-content md:ml-64 w-full min-h-screen">
        <!-- Top Navbar -->
        <div class="top-navbar bg-white px-6 py-4 flex justify-between items-center sticky top-0 z-30">
            <h1 class="text-xl font-semibold text-gray-800">
                <span id="pageTitle">Dashboard</span>
            </h1>
            <div class="flex items-center gap-4">
                <div class="hidden md:flex items-center gap-2 text-sm text-gray-600">
                    <i data-lucide="calendar" class="w-4 h-4"></i>
                    <span id="currentDate"></span>
                </div>
                <div class="flex items-center gap-3 bg-gray-100 rounded-full py-1 px-3">
                    <div class="bg-blue-100 p-1 rounded-full">
                        <i data-lucide="user" class="w-4 h-4 text-blue-600"></i>
                    </div>
                    <span class="text-gray-800 font-medium text-sm">
                        <?php echo e(Auth::user()->name); ?>

                    </span>
                </div>
            </div>
        </div>

        <!-- Page Content -->
        <div class="p-6">
            <?php echo $__env->yieldContent('content'); ?>
        </div>

        <!-- Footer -->
        <div class="bg-white border-t py-4 px-6 text-center">
            <p class="text-gray-600 text-sm">© <?php echo e(date('Y')); ?> Inventory Apotik. All rights reserved.</p>
        </div>
    </div>

    <!-- Logout Modal -->
    <div id="logoutModal" class="hidden fixed inset-0 flex items-center justify-center bg-black bg-opacity-50 z-50 p-4">
        <div class="bg-white rounded-xl p-6 w-full max-w-md shadow-xl">
            <div class="flex items-center gap-3 mb-4">
                <div class="bg-red-100 p-2 rounded-full">
                    <i data-lucide="log-out" class="w-6 h-6 text-red-600"></i>
                </div>
                <h2 class="text-lg font-semibold">Konfirmasi Logout</h2>
            </div>
            <p class="text-gray-600 mb-6">Apakah Anda yakin ingin keluar dari sistem?</p>
            <div class="flex justify-end space-x-3">
                <button onclick="hideLogoutModal()" class="px-4 py-2 border border-gray-300 text-gray-700 rounded-lg hover:bg-gray-50 transition">Batal</button>
                <form method="POST" action="<?php echo e(route('logout')); ?>">
                    <?php echo csrf_field(); ?>
                    <button type="submit" class="px-4 py-2 bg-red-600 text-white rounded-lg hover:bg-red-700 transition flex items-center gap-2">
                        <i data-lucide="log-out" class="w-4 h-4"></i> Logout
                    </button>
                </form>
            </div>
        </div>
    </div>

    <script>
        // Initialize Lucide icons
        lucide.createIcons();
        
        // Set current date
        function setCurrentDate() {
            const now = new Date();
            const options = { weekday: 'long', year: 'numeric', month: 'long', day: 'numeric' };
            document.getElementById('currentDate').textContent = now.toLocaleDateString('id-ID', options);
        }
        
        // Mobile sidebar toggle
        function toggleSidebar() {
            document.getElementById('sidebar').classList.toggle('open');
            document.getElementById('overlay').classList.toggle('open');
        }
        
        function closeSidebar() {
            document.getElementById('sidebar').classList.remove('open');
            document.getElementById('overlay').classList.remove('open');
        }
        
        // Logout modal functions
        function showLogoutModal() {
            document.getElementById('logoutModal').classList.remove('hidden');
        }
        
        function hideLogoutModal() {
            document.getElementById('logoutModal').classList.add('hidden');
        }
        
        // Set active page title
        function setPageTitle() {
            const activeLink = document.querySelector('.nav-item.active');
            if (activeLink) {
                const pageTitle = activeLink.querySelector('span').textContent;
                document.getElementById('pageTitle').textContent = pageTitle;
            }
        }
        
        // Initialize on page load
        document.addEventListener('DOMContentLoaded', function() {
            setCurrentDate();
            setPageTitle();
            
            // Add event listener for menu toggle on mobile
            document.getElementById('menuToggle').addEventListener('click', toggleSidebar);
            
            // Close sidebar when clicking outside on mobile
            document.getElementById('overlay').addEventListener('click', closeSidebar);
            
            // Close sidebar when resizing to desktop
            window.addEventListener('resize', function() {
                if (window.innerWidth >= 768) {
                    closeSidebar();
                }
            });
        });
    </script>

    <script src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js" defer></script>
    <?php echo $__env->yieldContent('scripts'); ?>
</body>
</html><?php /**PATH D:\inventory-apotik\resources\views/admin/layout.blade.php ENDPATH**/ ?>