@extends('karyawan.layout')

@section('content')
<div class="bg-white rounded-xl shadow p-6">
    <h2 class="text-2xl font-bold mb-4">Riwayat Rekam Medik</h2>

    @if($transaksis->count() > 0)
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200 text-sm">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-4 py-2 text-left font-medium">ID Transaksi</th>
                        <th class="px-4 py-2 text-left font-medium">Pasien</th>
                        <th class="px-4 py-2 text-left font-medium">Dokter</th>
                        <th class="px-4 py-2 text-left font-medium">Tanggal</th>
                        <th class="px-4 py-2 text-left font-medium">Total</th>
                        <th class="px-4 py-2 text-left font-medium">Aksi</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-100">
                    @foreach($transaksis as $transaksi)
                        <tr>
                            <td class="px-4 py-2">{{ $transaksi->id }}</td>
                            <td class="px-4 py-2">{{ $transaksi->rekamMedik->nama_pasien ?? 'N/A' }}</td>
                            <td class="px-4 py-2">{{ $transaksi->rekamMedik->dokter->name ?? 'N/A' }}</td>
                            <td class="px-4 py-2">{{ $transaksi->tanggal_transaksi->format('d/m/Y') }}</td>
                            <td class="px-4 py-2">Rp {{ number_format($transaksi->total, 0, ',', '.') }}</td>
                            <td class="px-4 py-2">
                                <a href="{{ route('karyawan.transaksi.show', $transaksi->id) }}" class="text-blue-600 hover:text-blue-800">Lihat Detail</a>
                                <a href="{{ route('karyawan.print_rekam_medik', $transaksi->id) }}" class="text-green-600 hover:text-green-800 ml-2">Print PDF</a>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    @else
        <p class="text-gray-500">Belum ada riwayat rekam medik yang ditebus.</p>
    @endif
</div>
@endsection
