@extends('karyawan.layout')

@section('content')
<div class="bg-white rounded-xl shadow p-6">
    <h2 class="text-2xl font-bold mb-4">Detail Resep Dokter</h2>

    <div class="mb-4">
        <p><strong>Pasien:</strong> {{ $rekamMedik->nama_pasien }}</p>
        <p><strong>Dokter:</strong> {{ $rekamMedik->dokter->name }}</p>
        <p><strong>Tanggal:</strong> {{ $rekamMedik->created_at->format('d/m/Y H:i') }}</p>
    </div>

    <h3 class="text-lg font-semibold mb-2">Daftar Obat</h3>
    <table class="min-w-full divide-y divide-gray-200 text-sm mb-4">
        <thead class="bg-gray-50">
            <tr>
                <th class="px-4 py-2 text-left font-medium">Nama Obat</th>
                <th class="px-4 py-2 text-left font-medium">Dosis</th>
                <th class="px-4 py-2 text-left font-medium">Aturan Pakai</th>
                <th class="px-4 py-2 text-left font-medium">Jumlah</th>
            </tr>
        </thead>
        <tbody class="divide-y divide-gray-100">
            @foreach ($rekamMedik->resep->obats as $obat)
                <tr>
                    <td class="px-4 py-2">{{ $obat->nama }}</td>
                    <td class="px-4 py-2">{{ $obat->pivot->dosis }}</td>
                    <td class="px-4 py-2">{{ $obat->pivot->aturan_pakai }}</td>
                    <td class="px-4 py-2">{{ $obat->pivot->jumlah }}</td>
                </tr>
            @endforeach
        </tbody>
    </table>

    <form action="{{ route('karyawan.transaksi.rekam_medik.store', $rekamMedik->id) }}" method="POST">
        @csrf
        <button type="submit"
            class="bg-green-600 text-white px-4 py-2 rounded-lg hover:bg-green-700">
            Tebus Obat
        </button>
    </form>
</div>
@endsection
