@extends('karyawan.layout')

@section('content')
<div class="bg-white rounded-xl shadow p-6">
    <h2 class="text-2xl font-bold mb-4">Daftar Resep Dokter</h2>

    <table class="min-w-full divide-y divide-gray-200 text-sm">
        <thead class="bg-gray-50">
            <tr>
                <th class="px-4 py-2 text-left font-medium">Tanggal</th>
                <th class="px-4 py-2 text-left font-medium">Nama Pasien</th>
                <th class="px-4 py-2 text-left font-medium">Dokter</th>
                <th class="px-4 py-2 text-left font-medium">Status</th>
                <th class="px-4 py-2 text-left font-medium">Aksi</th>
            </tr>
        </thead>
        <tbody class="divide-y divide-gray-100">
            @forelse ($rekamMediks as $rekam)
                <tr>
                    <td class="px-4 py-2">{{ $rekam->created_at->format('d/m/Y H:i') }}</td>
                    <td class="px-4 py-2">{{ $rekam->nama_pasien }}</td>
                    <td class="px-4 py-2">{{ $rekam->dokter->name }}</td>
                    <td class="px-4 py-2">
                        <span class="px-2 py-1 text-xs rounded-lg 
                            {{ $rekam->status == 'selesai' ? 'bg-green-100 text-green-700' : 'bg-yellow-100 text-yellow-700' }}">
                            {{ ucfirst($rekam->status) }}
                        </span>
                    </td>
                    <td class="px-4 py-2">
                        <a href="{{ route('karyawan.transaksi.rekam_medik', $rekam->id) }}"
                           class="bg-blue-600 text-white px-3 py-1 rounded-lg hover:bg-blue-700">
                            Tebus
                        </a>
                    </td>
                </tr>
            @empty
                <tr>
                    <td colspan="5" class="px-4 py-2 text-center text-gray-500">
                        Tidak ada resep dokter yang menunggu ditebus.
                    </td>
                </tr>
            @endforelse
        </tbody>
    </table>
</div>
@endsection
