<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Rekam Medik</title>
    <style>
        body { font-family: DejaVu Sans, sans-serif; font-size: 12px; }
        h2, h3 { margin: 5px 0; }
        table { width: 100%; border-collapse: collapse; margin-top: 15px; }
        th, td { border: 1px solid #000; padding: 5px; text-align: left; }
    </style>
</head>
<body>
    <h2 style="text-align:center;">Rekam Medik Pasien</h2>

    {{-- Data Pasien & Dokter --}}
    <p><strong>Tanggal:</strong> {{ $transaksi->tanggal_transaksi->format('d/m/Y H:i') }}</p>
    <p><strong>Pasien:</strong> {{ $transaksi->rekamMedik->nama_pasien }}</p>
    <p><strong>Dokter:</strong> {{ $transaksi->rekamMedik->resep->dokter->name ?? '-' }}</p>

    {{-- Keluhan & Penanganan --}}
    <p><strong>Keluhan:</strong><br>
        {{ $transaksi->rekamMedik->keluhan ?? '-' }}
    </p>
    <p><strong>Penanganan / Diagnosa:</strong><br>
        {{ $transaksi->rekamMedik->penanganan ?? '-' }}
    </p>

    {{-- Tabel Obat --}}
    <h3>Resep Obat</h3>
    <table>
        <thead>
            <tr>
                <th>Nama Obat</th>
                <th>Dosis</th>
                <th>Aturan Pakai</th>
                <th>Satuan</th>
                <th>Jumlah</th>
                <th>Harga</th>
                <th>Subtotal</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($transaksi->items as $item)
            <tr>
                <td>{{ $item->nama_obat }}</td>
                <td>{{ $item->obat->pivot->dosis ?? '-' }}</td>
                <td>{{ $item->obat->pivot->aturan_pakai ?? '-' }}</td>
                <td>{{ $item->satuan }}</td>
                <td>{{ $item->jumlah }}</td>
                <td>Rp. {{ number_format($item->harga_satuan, 0, ',', '.') }}</td>
                <td>Rp. {{ number_format($item->subtotal, 0, ',', '.') }}</td>
            </tr>
            @endforeach
        </tbody>
    </table>

    {{-- Total --}}
    <h3 style="text-align:right; margin-top:10px;">
        Total: Rp. {{ number_format($transaksi->total, 0, ',', '.') }}
    </h3>

    <p style="margin-top:40px; text-align:right;">
        <em>Dokter: {{ $transaksi->rekamMedik->resep->dokter->name ?? '-' }}</em>
    </p>
</body>
</html>
