@extends('karyawan.layout')

@section('content')
<div class="max-w-6xl mx-auto px-4 py-6">
    <h1 class="text-2xl font-bold mb-6 text-gray-800">Daftar Obat</h1>

    <form method="GET" action="{{ route('karyawan.obat.index') }}" class="mb-4">
        <div class="flex items-center gap-2">
            <input type="text" name="cari" value="{{ request('cari') }}" placeholder="Cari nama obat..."
                class="w-full md:w-1/3 px-4 py-2 border border-gray-300 rounded-lg shadow-sm focus:outline-none focus:ring-2 focus:ring-blue-500">
            <button type="submit"
                class="px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700 transition">
                Cari
            </button>
        </div>
    </form>

    <div class="overflow-x-auto bg-white shadow-md rounded-lg">
        <table class="min-w-full table-auto">
            <thead class="bg-gray-100 text-gray-700 uppercase text-sm font-semibold">
                <tr>
                    <th class="px-4 py-3 text-left">No</th>
                    <th class="px-4 py-3 text-left">Nama Obat</th>
                    <th class="px-4 py-3 text-left">Kategori</th>
                    <th class="px-4 py-3 text-left">Stok</th>
                    <th class="px-4 py-3 text-left">Harga</th>
                </tr>
            </thead>
            <tbody class="text-gray-700 divide-y divide-gray-200">
                @forelse($obats as $index => $obat)
                <tr class="hover:bg-gray-50">
                    <td class="px-4 py-3">{{ ($obats->currentPage() - 1) * $obats->perPage() + $index + 1 }}</td>
                    <td class="px-4 py-3 font-medium">{{ $obat->nama }}</td>
                    <td class="px-4 py-3">{{ $obat->kategori->nama ?? '-' }}</td>
                    <td class="px-4 py-3">{{ $obat->stok }}</td>
                    <td class="px-4 py-3">Rp{{ number_format($obat->harga, 0, ',', '.') }}</td>
                </tr>
                @empty
                <tr>
                    <td colspan="5" class="text-center px-4 py-6 text-gray-500">Data tidak ditemukan.</td>
                </tr>
                @endforelse
            </tbody>
        </table>
    </div>

    <div class="mt-4">
        {{ $obats->withQueryString()->links('pagination::tailwind') }}
    </div>
</div>
@endsection
