<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Dashboard Karyawan - Sistem Apotik</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js" defer></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap');
        :root {
            --primary: #2563eb;
            --primary-dark: #1d4ed8;
            --secondary: #0ea5e9;
            --accent: #f97316;
            --light: #f8fafc;
            --dark: #1e293b;
        }
        body { 
            font-family: 'Poppins', sans-serif; 
            background-color: #f1f5f9; 
            color: #334155;
        }
        .sidebar {
            background: linear-gradient(to bottom, var(--primary), var(--primary-dark));
            box-shadow: 0 0 25px rgba(0, 0, 0, 0.15);
            transition: all 0.3s ease;
            height: 100vh;
            display: flex;
            flex-direction: column;
            justify-content: space-between;
            position: fixed;
            width: 17rem;
            color: white;
            overflow-y: auto;
            z-index: 40;
        }
        .nav-item { 
            transition: all 0.2s ease; 
            border-radius: 8px; 
            color: white; 
            position: relative;
        }
        .nav-item:hover { 
            background-color: rgba(255, 255, 255, 0.12); 
            transform: translateX(5px); 
        }
        .nav-item.active { 
            background-color: rgba(255, 255, 255, 0.18); 
            font-weight: 500;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
        }
        .nav-item.active::before {
            content: '';
            position: absolute;
            left: 0;
            top: 0;
            height: 100%;
            width: 4px;
            background-color: white;
            border-radius: 4px 0 0 4px;
        }
        .main-content { 
            transition: margin-left 0.3s ease; 
            background-color: #f8fafc;
        }
        .top-navbar { 
            box-shadow: 0 2px 15px rgba(0, 0, 0, 0.08); 
            backdrop-filter: blur(10px); 
            background: rgba(255, 255, 255, 0.95);
            z-index: 30;
        }
        .card {
            background: white;
            border-radius: 12px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.05);
            transition: all 0.3s ease;
        }
        .card:hover {
            transform: translateY(-3px);
            box-shadow: 0 6px 16px rgba(0, 0, 0, 0.08);
        }
        @media (max-width: 768px) {
            .sidebar { 
                transform: translateX(-100%); 
                width: 75%;
            }
            .sidebar.open { 
                transform: translateX(0); 
                box-shadow: 0 0 30px rgba(0, 0, 0, 0.2);
            }
            .main-content { 
                margin-left: 0 !important;
                padding: 1rem;
                margin-top: 4rem;
            }
            .overlay { 
                display: none; 
                position: fixed; 
                top: 0; 
                left: 0; 
                right: 0; 
                bottom: 0; 
                background-color: rgba(0, 0, 0, 0.5); 
                z-index: 35; 
            }
            .overlay.open { 
                display: block; 
            }
            .top-navbar {
                padding: 0.75rem 1rem;
            }
            .user-info {
                display: none;
            }
        }
        .logout-container {
            border-top: 1px solid rgba(147, 197, 253, 0.5);
            padding: 1.5rem;
            background: rgba(255, 255, 255, 0.05);
        }
        .notification-badge {
            position: absolute;
            top: -5px;
            right: -5px;
            background-color: var(--accent);
            color: white;
            border-radius: 50%;
            width: 18px;
            height: 18px;
            font-size: 0.7rem;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        .logo-container {
            background: linear-gradient(135deg, #fff 0%, #e0f2fe 100%);
            border-radius: 12px;
            padding: 0.75rem;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
        }
        .user-avatar {
            transition: all 0.3s ease;
        }
        .user-avatar:hover {
            transform: scale(1.05);
            box-shadow: 0 0 0 3px rgba(37, 99, 235, 0.3);
        }
        .menu-indicator {
            transition: all 0.3s ease;
        }
        .submenu {
            overflow: hidden;
            transition: all 0.3s ease;
        }
        .submenu-item {
            padding-left: 2.5rem;
            font-size: 0.9rem;
            position: relative;
            display: block;
            padding-top: 0.5rem;
            padding-bottom: 0.5rem;
            transition: all 0.2s ease;
        }
        .submenu-item::before {
            content: '';
            position: absolute;
            left: 1.5rem;
            top: 50%;
            height: 1px;
            width: 0.75rem;
            background-color: rgba(255, 255, 255, 0.5);
        }
        .submenu-item.active {
            background-color: rgba(255, 255, 255, 0.15);
            font-weight: 500;
        }
        .submenu-item:hover {
            background-color: rgba(255, 255, 255, 0.1);
            transform: translateX(3px);
        }
        .user-dropdown {
            display: none;
            position: absolute;
            top: 100%;
            right: 0;
            width: 200px;
            background: white;
            border-radius: 8px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
            margin-top: 8px;
            z-index: 50;
            overflow: hidden;
        }
        .user-dropdown.open {
            display: block;
            animation: fadeIn 0.2s ease;
        }
        .user-dropdown-item {
            padding: 0.75rem 1rem;
            display: flex;
            align-items: center;
            gap: 0.5rem;
            color: #334155;
            transition: all 0.2s ease;
        }
        .user-dropdown-item:hover {
            background-color: #f1f5f9;
        }
        .user-dropdown-item.logout {
            color: #ef4444;
            border-top: 1px solid #e2e8f0;
        }
        .user-dropdown-item.logout:hover {
            background-color: #fef2f2;
        }
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(-10px); }
            to { opacity: 1; transform: translateY(0); }
        }
        /* Modal Styles */
        .modal {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, 0.5);
            z-index: 100;
            align-items: center;
            justify-content: center;
        }
        .modal.open {
            display: flex;
        }
        .modal-content {
            background-color: white;
            border-radius: 12px;
            width: 90%;
            max-width: 400px;
            padding: 1.5rem;
            box-shadow: 0 10px 25px rgba(0, 0, 0, 0.2);
        }
        .modal-actions {
            display: flex;
            justify-content: flex-end;
            gap: 1rem;
            margin-top: 1.5rem;
        }
        .btn {
            padding: 0.5rem 1rem;
            border-radius: 8px;
            font-weight: 500;
            cursor: pointer;
            transition: all 0.2s ease;
        }
        .btn-primary {
            background-color: var(--primary);
            color: white;
        }
        .btn-primary:hover {
            background-color: var(--primary-dark);
        }
        .btn-secondary {
            background-color: #e5e7eb;
            color: #4b5563;
        }
        .btn-secondary:hover {
            background-color: #d1d5db;
        }
        .btn-danger {
            background-color: #ef4444;
            color: white;
        }
        .btn-danger:hover {
            background-color: #dc2626;
        }
    </style>
</head>
<body class="flex flex-col min-h-screen" x-data="{ userDropdownOpen: false, logoutModalOpen: false }" @click.away="userDropdownOpen = false">
    <!-- Mobile menu button -->
    <div class="md:hidden fixed top-4 left-4 z-50">
        <button id="menuToggle" class="p-2 rounded-md bg-blue-600 text-white shadow-lg hover:bg-blue-700 transition-all">
            <i class="fas fa-bars"></i>
        </button>
    </div>

    <!-- Overlay for mobile -->
    <div id="overlay" class="overlay" onclick="closeSidebar()"></div>

    <!-- Header -->
    <header class="top-navbar px-6 py-3 flex justify-between items-center sticky top-0">
        <div class="flex items-center">
            <h2 class="text-xl font-semibold text-gray-800">
                <span id="pageTitle">Dashboard Karyawan</span>
            </h2>
        </div>
        <div class="flex items-center gap-5">
            <div class="hidden md:flex items-center gap-2 text-sm text-gray-600 bg-blue-50 py-1 px-3 rounded-full">
                <i class="far fa-calendar-alt text-blue-600"></i>
                <span id="currentDate"></span>
            </div>
            
            <div class="relative cursor-pointer">
                <div class="bg-blue-100 p-2 rounded-full">
                    <i class="fas fa-bell text-blue-600"></i>
                </div>
                <span class="notification-badge">3</span>
            </div>
            
            <div class="relative">
                <div class="flex items-center gap-3 bg-gray-50 rounded-full py-1 px-3 border border-gray-100 cursor-pointer" @click="userDropdownOpen = !userDropdownOpen">
                    <div class="user-avatar bg-blue-100 p-1 rounded-full">
                        <i class="fas fa-user-circle text-blue-600"></i>
                    </div>
                    <span class="text-gray-800 font-medium text-sm user-info">
                        Kasir Utama
                    </span>
                    <i class="fas fa-chevron-down text-gray-500 text-xs transition-transform" :class="{'rotate-180': userDropdownOpen}"></i>
                </div>
                
                <!-- User Dropdown Menu -->
                <div class="user-dropdown" :class="{'open': userDropdownOpen}">
                    <a href="#" class="user-dropdown-item">
                        <i class="fas fa-user text-gray-500"></i>
                        <span>Profil Saya</span>
                    </a>
                    <a href="#" class="user-dropdown-item">
                        <i class="fas fa-cog text-gray-500"></i>
                        <span>Pengaturan</span>
                    </a>
                    <a href="#" class="user-dropdown-item logout" @click="logoutModalOpen = true; userDropdownOpen = false">
                        <i class="fas fa-sign-out-alt"></i>
                        <span>Logout</span>
                    </a>
                </div>
            </div>
        </div>
    </header>

    <div class="flex flex-1">
        <!-- Sidebar -->
        <aside id="sidebar" class="sidebar">
            <div class="p-6">
                <!-- Logo -->
                <div class="flex items-center gap-3 mb-8 pt-4">
                    <div class="logo-container">
                        <i class="fas fa-pills text-blue-600 text-2xl"></i>
                    </div>
                    <div>
                        <h1 class="text-xl font-bold">Apotik Sehat</h1>
                        <p class="text-xs opacity-80">Karyawan Dashboard</p>
                    </div>
                </div>

                <!-- Navigation -->
                <nav class="space-y-2">
                    <a href="{{ route('karyawan.dashboard') }}" class="nav-item flex items-center gap-3 py-3 px-4 rounded-lg active">
                        <i class="fas fa-th-large"></i>
                        <span>Dashboard</span>
                        <div class="menu-indicator ml-auto">
                            <i class="fas fa-chevron-right text-xs"></i>
                        </div>
                    </a>

                    <!-- Riwayat Transaksi (parent menu) -->
                    <div x-data="{ open: true }" class="nav-item">
                        <button @click="open = !open" 
                            class="flex items-center justify-between w-full py-3 px-4 rounded-lg active">
                            <div class="flex items-center gap-3">
                                <i class="fas fa-history"></i>
                                <span>Riwayat Transaksi</span>
                            </div>
                            <i :class="open ? 'fas fa-chevron-down' : 'fas fa-chevron-right'" class="transition-all text-xs"></i>
                        </button>

                        <!-- Submenu -->
                        <div x-show="open" x-transition class="submenu mt-2 space-y-1">
                            <a href="{{ route('karyawan.transaksi.index') }}"
                                class="submenu-item block py-2 px-3 rounded-md text-sm active">
                                Riwayat Pembelian Tanpa Resep
                            </a>
                            <a href="{{ route('karyawan.transaksi.rekam_medik.list') }}"
                                class="submenu-item block py-2 px-3 rounded-md text-sm">
                                Riwayat Rekam Medik
                            </a>
                        </div>
                    </div>

                    <a href="{{ route('karyawan.transaksi.create') }}" class="nav-item flex items-center gap-3 py-3 px-4 rounded-lg">
                        <i class="fas fa-cash-register"></i>
                        <span>Transaksi Tanpa Resep</span>
                        <div class="menu-indicator ml-auto">
                            <i class="fas fa-chevron-right text-xs"></i>
                        </div>
                    </a>

                    <a href="{{ route('karyawan.transaksi.rekam_medik.list') }}" class="nav-item flex items-center gap-3 py-3 px-4 rounded-lg">
                        <i class="fas fa-notes-medical"></i>
                        <span>Rekam Medik</span>
                        <div class="menu-indicator ml-auto">
                            <i class="fas fa-chevron-right text-xs"></i>
                        </div>
                    </a>
                </nav>
            </div>

            <!-- Logout Button -->
            <div class="logout-container mt-auto">
                <a href="#" class="nav-item flex items-center gap-3 py-3 px-4 rounded-lg hover:bg-red-500/20 w-full text-left transition-all" onclick="openLogoutModal()">
                    <i class="fas fa-sign-out-alt"></i>
                    <span>Logout</span>
                    <div class="menu-indicator ml-auto">
                        <i class="fas fa-chevron-right text-xs"></i>
                    </div>
                </a>
            </div>
        </aside>
    </div>

    <main class="main-content flex-1 p-6 ml-[17rem] mt-16">
        @yield('content')
    </main>

    <!-- Footer -->
    <footer class="bg-gray-800 text-white py-4 text-center mt-auto">
        <p class="text-sm">© 2025 Sistem Apotik. All rights reserved.</p>
    </footer>

    <!-- Logout Modal -->
    <div class="modal" :class="{'open': logoutModalOpen}">
        <div class="modal-content">
            <h3 class="text-lg font-semibold text-gray-800">Konfirmasi Logout</h3>
            <p class="mt-2 text-gray-600">Apakah Anda yakin ingin keluar dari sistem?</p>