@extends('dokter.layout')

@section('content')
<div class="container mx-auto px-4 py-6">
    <div class="bg-white shadow rounded-2xl p-6 space-y-6">

        {{-- Header --}}
        <div class="flex items-center justify-between">
            <h1 class="text-2xl font-bold text-gray-800">🧾 Detail Resep</h1>
            <span class="text-sm text-gray-500">Tanggal dibuat: {{ $resep->created_at->format('d M Y') }}</span>
        </div>

        {{-- Info Resep --}}
        <div class="bg-gray-50 rounded-lg p-4 border border-gray-200">
            <p class="text-gray-600 text-sm">Kode Resep</p>
            <h2 class="text-lg font-semibold text-gray-900">{{ $resep->kode_resep }}</h2>
        </div>

        {{-- Flash Message --}}
        @if (session('success'))
            <div class="bg-green-100 border border-green-300 text-green-800 px-4 py-3 rounded">
                {{ session('success') }}
            </div>
        @endif

        {{-- Tabel Obat --}}
        <div>
            <h2 class="text-xl font-semibold text-gray-800 mb-3">💊 Daftar Obat</h2>
            @if ($resep->resepObats->count())
                <div class="overflow-x-auto rounded-lg border border-gray-200">
                    <table class="min-w-full bg-white text-sm text-left">
                        <thead class="bg-gray-100 text-gray-700 uppercase text-xs">
                            <tr>
                                <th class="px-4 py-3">Nama Obat</th>
                                <th class="px-4 py-3">Dosis</th>
                                <th class="px-4 py-3">Aturan Pakai</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-gray-200">
                            @foreach ($resep->resepObats as $item)
                                <tr class="hover:bg-gray-50">
                                    <td class="px-4 py-3 font-medium">{{ $item->obat->nama }}</td>
                                    <td class="px-4 py-3">{{ $item->dosis }}</td>
                                    <td class="px-4 py-3">{{ $item->aturan_pakai }}</td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            @else
                <p class="text-gray-500 italic">Belum ada obat yang ditambahkan ke resep ini.</p>
            @endif
        </div>

        {{-- Tombol Tambah Obat --}}
        <div class="text-right">
            <button onclick="toggleModal(true)" class="bg-blue-600 hover:bg-blue-700 text-white px-5 py-2 rounded-md shadow-sm transition">
                + Tambah Obat ke Resep
            </button>
        </div>
    </div>
</div>

{{-- Modal Tambah Obat --}}
<div id="modalTambahObat" class="fixed inset-0 z-50 flex items-center justify-center bg-black bg-opacity-40 hidden">
    <div class="bg-white w-full max-w-md rounded-xl shadow-lg p-6 relative space-y-4">
        <h2 class="text-lg font-semibold text-gray-800">Tambah Obat ke Resep</h2>

        <form action="{{ route('dokter.reseps.obats.store', $resep->id) }}" method="POST">
            @csrf

            {{-- Pilih Obat --}}
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-1">Pilih Obat</label>
                <select name="obat_id" required class="w-full border border-gray-300 rounded-md px-3 py-2">
                    <option value="">-- Pilih Obat --</option>
                    @foreach ($obats as $obat)
                        <option value="{{ $obat->id }}">{{ $obat->nama }}</option>
                    @endforeach
                </select>
                @error('obat_id')
                    <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                @enderror
            </div>

            {{-- Dosis --}}
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-1">Dosis</label>
                <input type="text" name="dosis" required class="w-full border border-gray-300 rounded-md px-3 py-2">
                @error('dosis')
                    <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                @enderror
            </div>

            {{-- Aturan Pakai --}}
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-1">Aturan Pakai</label>
                <input type="text" name="aturan_pakai" required class="w-full border border-gray-300 rounded-md px-3 py-2">
                @error('aturan_pakai')
                    <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                @enderror
            </div>

            <div class="flex justify-end gap-3 mt-6">
                <button type="button" onclick="toggleModal(false)" class="px-4 py-2 bg-gray-400 text-white rounded hover:bg-gray-500">Batal</button>
                <button type="submit" class="px-4 py-2 bg-green-600 text-white rounded hover:bg-green-700">Simpan</button>
            </div>
        </form>
    </div>
</div>

{{-- Modal Logic --}}
<script>
    function toggleModal(show) {
        const modal = document.getElementById('modalTambahObat');
        modal.classList.toggle('hidden', !show);
    }

    // Tutup modal jika klik di luar
    document.addEventListener('click', function (e) {
        const modal = document.getElementById('modalTambahObat');
        const box = modal.querySelector('.bg-white');
        if (e.target === modal && !box.contains(e.target)) {
            toggleModal(false);
        }
    });
</script>
@endsection
