@extends('dokter.layout')

@section('content')
<div class="max-w-xl mx-auto bg-white shadow-md rounded-2xl p-6 space-y-6">

    {{-- Judul --}}
    <div class="flex items-center justify-between">
        <h1 class="text-2xl font-bold text-gray-800">✏️ Edit Resep</h1>
        <a href="{{ route('dokter.reseps.index') }}" class="text-sm text-gray-500 hover:underline">← Kembali ke daftar</a>
    </div>

    {{-- Form --}}
    <form action="{{ route('dokter.reseps.update', $resep->id) }}" method="POST" class="space-y-5">
        @csrf
        @method('PUT')

        {{-- Kode Resep --}}
        <div>
            <label class="block text-sm font-medium text-gray-700 mb-1">Kode Resep</label>
            <input type="text" name="kode_resep" value="{{ old('kode_resep', $resep->kode_resep) }}" required
                class="w-full border border-gray-300 rounded-md px-4 py-2 shadow-sm focus:outline-none focus:ring-2 focus:ring-indigo-500">
            @error('kode_resep')
                <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
            @enderror
        </div>

        {{-- Keterangan --}}
        <div class="bg-yellow-50 border-l-4 border-yellow-400 text-yellow-800 p-4 text-sm rounded">
            <strong>Catatan:</strong> Obat dalam resep ini tidak bisa diubah di sini.<br>
            Jika ingin menambah atau menghapus obat, gunakan halaman <a href="{{ route('dokter.reseps.show', $resep->id) }}" class="underline font-semibold text-yellow-700">Detail Resep</a>.
        </div>

        {{-- Tombol --}}
        <div class="flex justify-end gap-3 pt-2">
            <a href="{{ route('dokter.reseps.index') }}"
               class="px-4 py-2 rounded-md bg-gray-400 text-white hover:bg-gray-500 transition">Batal</a>
            <button type="submit" class="bg-indigo-600 text-white px-4 py-2 rounded hover:bg-indigo-700 flex items-center gap-2">
                 💾 <span>Simpan</span>
            </button>
        </div>

        {{-- Pesan Sukses --}}          
        </div>
    </form>
</div>
@endsection
