@extends('dokter.layout')

@section('content')
<div class="bg-white rounded-2xl shadow-lg overflow-hidden">
    <!-- Header -->
    <div class="bg-indigo-600 px-6 py-4">
        <h2 class="text-2xl font-bold text-white flex items-center">
            <i class="fas fa-file-medical mr-3"></i>Buat Rekam Medik Baru
        </h2>
        <p class="text-indigo-100 mt-1">Isi formulir rekam medik untuk pasien</p>
    </div>

    <form action="{{ route('dokter.rekammedik.store') }}" method="POST" class="p-6 space-y-6">
        @csrf

        <!-- Data Pasien -->
        <div class="border-b border-gray-200 pb-6">
            <h3 class="text-lg font-semibold text-gray-800 mb-4 flex items-center">
                <i class="fas fa-user-injured mr-2 text-indigo-600"></i>Data Pasien
            </h3>
            
            <div class="grid grid-cols-1 md:grid-cols-2 gap-5">
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Nama Pasien <span class="text-red-500">*</span></label>
                    <input type="text" name="nama_pasien" class="w-full border border-gray-300 rounded-xl px-4 py-3 focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500 transition" required>
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Umur <span class="text-red-500">*</span></label>
                    <input type="number" name="umur" class="w-full border border-gray-300 rounded-xl px-4 py-3 focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500 transition" min="0" required>
                </div>
                <div class="md:col-span-2">
                    <label class="block text-sm font-medium text-gray-700 mb-2">Alamat</label>
                    <input type="text" name="alamat" class="w-full border border-gray-300 rounded-xl px-4 py-3 focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500 transition">
                </div>
            </div>
        </div>

        <!-- Keluhan & Indikasi -->
        <div class="border-b border-gray-200 pb-6">
            <h3 class="text-lg font-semibold text-gray-800 mb-4 flex items-center">
                <i class="fas fa-stethoscope mr-2 text-indigo-600"></i>Diagnosa
            </h3>
            
            <div class="grid grid-cols-1 md:grid-cols-2 gap-5">
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Keluhan</label>
                    <textarea name="keluhan" class="w-full border border-gray-300 rounded-xl px-4 py-3 focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500 transition" rows="3" placeholder="Keluhan yang dirasakan pasien"></textarea>
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Indikasi</label>
                    <textarea name="indikasi" class="w-full border border-gray-300 rounded-xl px-4 py-3 focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500 transition" rows="3" placeholder="Indikasi atau gejala yang ditemukan"></textarea>
                </div>
            </div>
        </div>

        <!-- Penanganan -->
        <div class="border-b border-gray-200 pb-6">
            <h3 class="text-lg font-semibold text-gray-800 mb-4 flex items-center">
                <i class="fas fa-hand-holding-medical mr-2 text-indigo-600"></i>Penanganan
            </h3>
            
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">Tindakan & Penanganan</label>
                <textarea name="penanganan" class="w-full border border-gray-300 rounded-xl px-4 py-3 focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500 transition" rows="3" placeholder="Tindakan medis yang diberikan"></textarea>
            </div>
        </div>

        <!-- Resep Obat -->
        <div class="pb-6">
            <h3 class="text-lg font-semibold text-gray-800 mb-4 flex items-center">
                <i class="fas fa-pills mr-2 text-indigo-600"></i>Resep Obat
            </h3>
            
            <div class="bg-gray-50 rounded-xl p-4 border border-gray-200">
                <div id="obatContainer" class="space-y-4">
                    <div class="obat-item bg-white p-4 rounded-xl border border-gray-200">
                        <div class="grid grid-cols-1 md:grid-cols-12 gap-4 items-center">
                            <div class="md:col-span-4">
                                <label class="block text-xs text-gray-600 mb-1">Nama Obat <span class="text-red-500">*</span></label>
                                <select name="obat_id[]" class="w-full border border-gray-300 rounded-lg px-3 py-2 focus:ring-2 focus:ring-indigo-500" required>
                                    <option value="">Pilih Obat</option>
                                    @foreach($obats as $obat)
                                        <option value="{{ $obat->id }}">{{ $obat->nama }}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="md:col-span-2">
                                <label class="block text-xs text-gray-600 mb-1">Dosis <span class="text-red-500">*</span></label>
                                <input type="text" name="dosis[]" class="w-full border border-gray-300 rounded-lg px-3 py-2 focus:ring-2 focus:ring-indigo-500" placeholder="Contoh: 1x1" required>
                            </div>
                            <div class="md:col-span-2">
                                <label class="block text-xs text-gray-600 mb-1">Jumlah <span class="text-red-500">*</span></label>
                                <input type="number" name="jumlah[]" class="w-full border border-gray-300 rounded-lg px-3 py-2 focus:ring-2 focus:ring-indigo-500" min="1" value="1" required>
                            </div>
                            <div class="md:col-span-3">
                                <label class="block text-xs text-gray-600 mb-1">Aturan Pakai <span class="text-red-500">*</span></label>
                                <input type="text" name="aturan_pakai[]" class="w-full border border-gray-300 rounded-lg px-3 py-2 focus:ring-2 focus:ring-indigo-500" placeholder="Contoh: Setelah makan" required>
                            </div>
                            <div class="md:col-span-2 flex justify-center pt-5">
                                <button type="button" class="hapus-obat bg-red-500 hover:bg-red-600 text-white p-2 rounded-lg flex items-center justify-center transition">
                                    <i class="fas fa-trash"></i>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
                
                <button type="button" id="tambahObat" class="mt-4 bg-indigo-600 hover:bg-indigo-700 text-white px-4 py-2.5 rounded-xl flex items-center transition">
                    <i class="fas fa-plus-circle mr-2"></i> Tambah Obat Lain
                </button>
            </div>
        </div>

        <!-- Submit -->
        <div class="flex justify-end gap-4 pt-4">
            <a href="{{ route('dokter.rekammedik.index') }}" class="px-5 py-2.5 border border-gray-300 text-gray-700 rounded-xl hover:bg-gray-50 transition flex items-center">
                <i class="fas fa-times mr-2"></i> Batal
            </a>
            <button type="submit" class="px-5 py-2.5 bg-green-600 hover:bg-green-700 text-white rounded-xl transition flex items-center">
                <i class="fas fa-save mr-2"></i> Simpan Rekam Medik
            </button>
        </div>
    </form>
</div>
@endsection

@section('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    const tambahObatBtn = document.getElementById('tambahObat');
    const obatContainer = document.getElementById('obatContainer');
    
    // Tambah obat
    tambahObatBtn.addEventListener('click', function() {
        const newItem = obatContainer.firstElementChild.cloneNode(true);
        
        // Clear values
        newItem.querySelectorAll('select, input').forEach(el => {
            el.value = '';
            if (el.tagName === 'SELECT') {
                el.selectedIndex = 0;
            }
        });
        
        obatContainer.appendChild(newItem);
        
        // Add event listener to new delete button
        newItem.querySelector('.hapus-obat').addEventListener('click', function() {
            hapusObat(this);
        });
    });
    
    // Hapus obat
    function hapusObat(button) {
        const items = document.querySelectorAll('.obat-item');
        if (items.length > 1) {
            button.closest('.obat-item').remove();
        } else {
            alert('Minimal satu obat harus ditambahkan!');
        }
    }
    
    // Add event listeners to initial delete buttons
    document.querySelectorAll('.hapus-obat').forEach(button => {
        button.addEventListener('click', function() {
            hapusObat(this);
        });
    });
});
</script>

<!-- Include Font Awesome -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

<style>
    .obat-item {
        transition: all 0.3s ease;
    }
    
    .obat-item:hover {
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.05);
    }
    
    input, select, textarea {
        transition: all 0.2s;
    }
    
    input:focus, select:focus, textarea:focus {
        box-shadow: 0 0 0 3px rgba(79, 70, 229, 0.2);
    }
</style>
@endsection