@extends('dokter.layout')

@section('content')
<div class="bg-white rounded-xl shadow p-6">
    <h2 class="text-xl font-semibold text-gray-800 mb-4">📋 Obat yang Sudah Diresepkan</h2>

    <table class="min-w-full divide-y divide-gray-200 text-sm">
        <thead class="bg-gray-100 text-gray-600">
            <tr>
                <th class="px-4 py-2 text-left">Nama Obat</th>
                <th class="px-4 py-2 text-left">Dosis</th>
                <th class="px-4 py-2 text-left">Aturan Pakai</th>
                <th class="px-4 py-2 text-left">Tanggal Resep</th>
            </tr>
        </thead>
        <tbody class="bg-white divide-y divide-gray-100">
            @forelse($obats as $obat)
                @php
                    $resep = $obat->reseps->first();
                @endphp
                <tr>
                    <td class="px-4 py-2 font-medium">{{ $obat->nama }}</td>
                    <td class="px-4 py-2">{{ $resep?->pivot?->dosis ?? '-' }}</td>
                    <td class="px-4 py-2">{{ $resep?->pivot?->aturan_pakai ?? '-' }}</td>
                    <td class="px-4 py-2">{{ optional($resep)->created_at?->format('d-m-Y') ?? '-' }}</td>
                </tr>
            @empty
                <tr>
                    <td colspan="4" class="text-center px-4 py-4 text-gray-500">
                        Belum ada obat yang diresepkan.
                    </td>
                </tr>
            @endforelse
        </tbody>
    </table>

    <div class="mt-4">
        {{ $obats->links('pagination::tailwind') }}
    </div>
</div>
@endsection
