@extends('admin.layout')

@section('content')
<div class="bg-white p-6 rounded shadow max-w-lg mx-auto">
    <h2 class="text-xl font-bold mb-4 text-gray-700">Tambah User Baru</h2>

    @if($errors->any())
        <div class="mb-4 text-red-600">
            <ul class="list-disc ml-6">
                @foreach($errors->all() as $err)
                    <li>{{ $err }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <form action="{{ route('admin.users.store') }}" method="POST" class="space-y-4">
        @csrf

        <div>
            <label class="block text-gray-600 mb-1">Nama</label>
            <input type="text" name="name" class="w-full border px-3 py-2 rounded" required>
        </div>

        <div>
            <label class="block text-gray-600 mb-1">Email</label>
            <input type="email" name="email" class="w-full border px-3 py-2 rounded" required>
        </div>

        <div>
            <label class="block text-gray-600 mb-1">Role</label>
            <select name="role" class="w-full border px-3 py-2 rounded" required>
                <option value="">-- Pilih Role --</option>
                <option value="dokter">Dokter</option>
                <option value="karyawan">Karyawan</option>
            </select>
        </div>

        <div>
            <label class="block text-gray-600 mb-1">Password</label>
            <input type="password" name="password" class="w-full border px-3 py-2 rounded" required>
        </div>

        <div>
            <label class="block text-gray-600 mb-1">Konfirmasi Password</label>
            <input type="password" name="password_confirmation" class="w-full border px-3 py-2 rounded" required>
        </div>

        <div class="text-right">
            <button type="submit" class="bg-blue-600 text-white px-4 py-2 rounded hover:bg-blue-700">
                Simpan
            </button>
        </div>
    </form>
</div>
@endsection
