@extends('admin.layout')

@section('content')
<div class="p-4">
    <h1 class="text-xl font-bold mb-4">Daftar Supplier</h1>
    <a href="{{ route('admin.suppliers.create') }}" class="bg-blue-500 text-white px-4 py-2 rounded">Tambah Supplier</a>
    <table class="mt-4 w-full border">
        <thead>
            <tr class="bg-gray-100">
                <th class="border p-2">Nama</th>
                <th class="border p-2">Alamat</th>
                <th class="border p-2">Telepon</th>
                <th class="border p-2">Aksi</th>
            </tr>
        </thead>
        <tbody>
            @foreach($suppliers as $supplier)
            <tr>
                <td class="border p-2">{{ $supplier->nama }}</td>
                <td class="border p-2">{{ $supplier->alamat }}</td>
                <td class="border p-2">{{ $supplier->telepon }}</td>
                <td class="border p-2">
                    <form action="{{ route('admin.suppliers.destroy', $supplier->id) }}" method="POST" onsubmit="return confirm('Yakin ingin menghapus?')">
                        @csrf
                        @method('DELETE')
                        <button class="text-red-500">Hapus</button>
                    </form>
                </td>
            </tr>
            @endforeach
        </tbody>
    </table>
</div>
@endsection
