@extends('admin.layout')

@section('content')
<div class="bg-white shadow-xl rounded-2xl p-8 max-w-2xl mx-auto">
    <h2 class="text-2xl font-bold text-gray-800 mb-6 text-center">Detail Pembelian</h2>

    {{-- Informasi Umum Pembelian --}}
    <div class="mb-6">
        <p class="text-sm text-gray-500">Supplier</p>
        <p class="text-lg font-semibold text-gray-800">{{ $pembelian->supplier->nama ?? '-' }}</p>
    </div>

    <div class="mb-6">
        <p class="text-sm text-gray-500">Tanggal Pembelian</p>
        <p class="text-lg font-semibold text-gray-800">{{ \Carbon\Carbon::parse($pembelian->tanggal_pembelian)->translatedFormat('d F Y') }}</p>
    </div>

    {{-- Detail Obat --}}
    <div class="border-t border-gray-200 pt-6">
        <h3 class="text-xl font-semibold text-gray-800 mb-4">Obat yang Dibeli</h3>
        @if($pembelian->details->isNotEmpty())
            <div class="space-y-4">
                @foreach($pembelian->details as $detail)
                <div class="bg-gray-50 rounded-xl p-5">
                    <p class="text-sm text-gray-500">Nama Obat</p>
                    <p class="text-lg font-semibold text-gray-800">{{ $detail->masterObat->nama ?? '-' }}</p>

                    <div class="grid grid-cols-2 gap-4 mt-4">
                        <div>
                            <p class="text-sm text-gray-500">Kode Barcode</p>
                            <p class="text-base font-medium">{{ $detail->kode_barcode ?? '-' }}</p>
                        </div>
                        <div>
                            <p class="text-sm text-gray-500">Jumlah</p>
                            <p class="text-base font-medium">{{ $detail->jumlah }} {{ $detail->satuan }}</p>
                        </div>
                        <div>
                            <p class="text-sm text-gray-500">Harga Beli</p>
                            <p class="text-base font-medium">Rp {{ number_format($detail->harga_beli, 0, ',', '.') }}</p>
                        </div>
                        <div>
                            <p class="text-sm text-gray-500">Harga Jual</p>
                            <p class="text-base font-medium">Rp {{ number_format($detail->harga_jual, 0, ',', '.') }}</p>
                        </div>
                        <div>
                            <p class="text-sm text-gray-500">Expired</p>
                            <p class="text-base font-medium">
                                {{ $detail->expired_at ? \Carbon\Carbon::parse($detail->expired_at)->translatedFormat('d F Y') : '-' }}
                            </p>
                        </div>
                    </div>

                    <div class="mt-4 border-t pt-3">
                        <p class="text-sm text-gray-500">Subtotal</p>
                        <p class="text-lg font-semibold text-green-600">Rp {{ number_format($detail->subtotal, 0, ',', '.') }}</p>
                    </div>
                </div>
                @endforeach
            </div>
        @else
            <p class="text-gray-500 italic">Tidak ada detail obat untuk pembelian ini.</p>
        @endif
    </div>

    {{-- Total Pembayaran --}}
    <div class="mt-6 text-right">
        <p class="text-sm text-gray-500">Total Pembayaran</p>
        <p class="text-2xl font-bold text-blue-600">Rp {{ number_format($pembelian->total_pembayaran, 0, ',', '.') }}</p>
    </div>

    {{-- Tombol Aksi --}}
    <div class="mt-8 flex justify-between">
        <a href="{{ route('admin.pembelian.index') }}" class="bg-gray-200 hover:bg-gray-300 text-gray-700 px-5 py-2 rounded-xl">Kembali</a>
        <a href="{{ route('admin.pembelian.cetak', $pembelian->id) }}" 
       class="bg-blue-600 text-white px-4 py-2 rounded hover:bg-blue-700 transition">
        Cetak PDF
    </a>
    </div>
</div>
@endsection
