@extends('admin.layout')

@section('content')
<div class="mb-6">
    <h1 class="text-2xl font-bold mb-4">Daftar Pembelian</h1>

    <!-- Pencarian -->
    <form method="GET" action="{{ route('admin.pembelian.index') }}" class="mb-4 flex items-center gap-2">
        <input type="text" name="q" value="{{ request('q') }}" placeholder="Cari nama obat..."
               class="border rounded-lg px-3 py-2 w-64 focus:ring focus:ring-blue-300">
        <button type="submit" class="bg-blue-600 text-white px-4 py-2 rounded-lg hover:bg-blue-700">
            Cari
        </button>
    </form>

    <!-- Tabel -->
    <div class="overflow-x-auto bg-white rounded-xl shadow">
        <table class="min-w-full divide-y divide-gray-200 text-sm">
            <thead class="bg-gray-100">
                <tr>
                    <th class="px-4 py-2 text-left font-semibold">No</th>
                    <th class="px-4 py-2 text-left font-semibold">Supplier</th>
                    <th class="px-4 py-2 text-left font-semibold">Nama Obat</th>
                    <th class="px-4 py-2 text-left font-semibold">Kode Barcode</th>
                    <th class="px-4 py-2 text-left font-semibold">Stok</th>
                    <th class="px-4 py-2 text-left font-semibold">Tanggal Pembelian</th>
                    <th class="px-4 py-2 text-left font-semibold">Total Pembayaran</th>
                    <th class="px-4 py-2 text-center font-semibold">Aksi</th>
                </tr>
            </thead>
            <tbody class="divide-y divide-gray-100">
                @forelse ($pembelians as $index => $pembelian)
                <tr class="hover:bg-gray-50">
                    <td class="px-4 py-2">{{ $pembelians->firstItem() + $index }}</td>
                    <td class="px-4 py-2">{{ $pembelian->supplier->nama ?? '-' }}</td>
                    <td class="px-4 py-2">
                        @php
                            $obatList = $pembelian->details->pluck('masterObat.nama')->take(3)->join(', ');
                            if ($pembelian->details->count() > 3) {
                                $obatList .= '...';
                            }
                        @endphp
                        {{ $obatList ?: '-' }}
                    </td>
                    <td class="px-4 py-2">
                        @php
                            $barcodeList = $pembelian->details->pluck('kode_barcode')->filter()->take(3)->join(', ');
                            if ($pembelian->details->count() > 3) {
                                $barcodeList .= '...';
                            }
                        @endphp
                        {{ $barcodeList ?: '-' }}
                    </td>
                    <td class="px-4 py-2">
                        @php
                            $stokList = $pembelian->details->pluck('jumlah')->take(3)->join(', ');
                            if ($pembelian->details->count() > 3) {
                                $stokList .= '...';
                            }
                        @endphp
                        {{ $stokList ?: '-' }}
                    </td>
                    <td class="px-4 py-2">{{ \Carbon\Carbon::parse($pembelian->tanggal_pembelian)->format('d M Y') }}</td>
                    <td class="px-4 py-2">Rp {{ number_format($pembelian->total_pembayaran, 0, ',', '.') }}</td>
                    <td class="px-4 py-2 text-center flex justify-center gap-2">
                        <a href="{{ route('admin.pembelian.show', $pembelian->id) }}"
                           class="bg-green-600 text-white px-3 py-1 rounded-lg hover:bg-green-700">
                           Detail
                        </a>
                        <form action="{{ route('admin.pembelian.destroy', $pembelian->id) }}" method="POST"
                              onsubmit="return confirm('Yakin ingin menghapus pembelian ini?');">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="bg-red-600 text-white px-3 py-1 rounded-lg hover:bg-red-700">
                                Hapus
                            </button>
                        </form>
                    </td>
                </tr>
                @empty
                    <tr>
                        <td colspan="6" class="px-4 py-4 text-center text-gray-500">
                            Tidak ada data pembelian.
                        </td>
                    </tr>
                @endforelse
            </tbody>
        </table>
    </div>

    <!-- Pagination -->
    <div class="mt-4">
        {{ $pembelians->withQueryString()->links() }}
    </div>
</div>
@endsection
