<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Cetak Pembelian</title>
    <style>
        body { font-family: DejaVu Sans, sans-serif; font-size: 12px; color: #333; margin: 20px; }
        .header { text-align: center; margin-bottom: 25px; }
        .header h2 { margin: 0; font-size: 18px; text-transform: uppercase; }
        .info { margin-bottom: 20px; line-height: 1.5; }
        .info div { margin: 2px 0; }
        .footer { margin-top: 30px; font-size: 10px; text-align: center; color: #555; }
        table { width: 100%; border-collapse: collapse; margin-top: 15px; }
        th, td { border: 1px solid #000; padding: 6px 8px; text-align: left; vertical-align: middle; }
        th { background-color: #f4f4f4; font-weight: bold; }
        tbody tr:nth-child(even) { background-color: #fafafa; }
        h3 { margin-bottom: 8px; }
    </style>
</head>
<body>
    <div class="header">
        <h2>Laporan Pembelian Obat</h2>
    </div>

    <div class="info">
        <div><strong>No. Pembelian:</strong> {{ $pembelian->id }}</div>
        <div><strong>Supplier:</strong> {{ $pembelian->supplier->nama ?? '-' }}</div>
        <div><strong>Tanggal Pembelian:</strong> {{ \Carbon\Carbon::parse($pembelian->tanggal_pembelian)->format('d M Y') }}</div>
        <div><strong>Total Pembayaran:</strong> Rp {{ number_format($pembelian->total_pembayaran, 0, ',', '.') }}</div>
    </div>

    <h3>Detail Obat</h3>
    <table>
        <thead>
            <tr>
                <th>Nama Obat</th>
                <th>Kode Barcode</th>
                <th>Jumlah</th>
                <th>Satuan</th>
                <th>Harga Beli</th>
                <th>Harga Jual</th>
                <th>Subtotal</th>
                <th>Expired</th>
            </tr>
        </thead>
        <tbody>
            @foreach($pembelian->details as $detail)
            <tr>
                <td>{{ $detail->masterObat->nama ?? '-' }}</td>
                <td>{{ $detail->kode_barcode ?? '-' }}</td>
                <td>{{ $detail->jumlah }}</td>
                <td>{{ $detail->satuan }}</td>
                <td>Rp {{ number_format($detail->harga_beli, 0, ',', '.') }}</td>
                <td>Rp {{ number_format($detail->harga_jual, 0, ',', '.') }}</td>
                <td>Rp {{ number_format($detail->subtotal, 0, ',', '.') }}</td>
                <td>{{ $detail->expired_at ? \Carbon\Carbon::parse($detail->expired_at)->format('d M Y') : '-' }}</td>
            </tr>
            @endforeach
        </tbody>
    </table>

    <div class="footer">
        Dicetak pada: {{ now()->format('d M Y H:i') }}
    </div>
</body>
</html>
