@extends('admin.layout')

@section('content')
<div class="mb-6">
    <h1 class="text-2xl font-bold mb-2">Data Obat</h1>
</div>

@if(session('success'))
    <div class="bg-green-100 text-green-700 px-4 py-2 rounded mb-4">
        {{ session('success') }}
    </div>
@endif

{{-- Pencarian Obat --}}
<div class="mb-6">
    <label for="obat-search" class="block text-sm font-semibold text-gray-700 mb-2">
        🔍 Cari Nama Obat
    </label>
    <div class="flex flex-col sm:flex-row items-center gap-2">
        <select id="obat-search" class="w-full sm:w-80 border border-gray-300 rounded-lg shadow-sm">
            <option value="">Ketik nama obat...</option>
        </select>
        
        @if(request('obat_id'))
            <a href="{{ route('admin.obats.index') }}"
               class="text-sm text-red-600 hover:underline whitespace-nowrap">
               🔄 Reset
            </a>
        @endif
    </div>
</div>

<div class="overflow-x-auto">
    <table class="w-full border border-gray-200 rounded-lg">
        <thead class="bg-gray-100">
            <tr class="text-left">
                <th class="p-2">No</th>
                <th class="p-2">Nama Obat</th>
                <th class="p-2">Kategori</th>
                <th class="p-2">Satuan</th>
                <th class="p-2">Stok</th>
                <th class="p-2">Harga</th>
                <th class="p-2">Expired</th>
                <th class="p-2">Supplier Terakhir</th>
                <th class="p-2">Aksi</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($obats as $obat)
            <tr class="border-t">
                <td class="p-2">{{ $loop->iteration }}</td>
                <td class="p-2">{{ $obat->nama }}</td>
                <td class="p-2">{{ $obat->kategori->nama ?? '-' }}</td>
                <td class="p-2">{{ $obat->satuan }}</td>
                <td class="p-2">{{ $obat->stok }}</td>
                <td class="p-2">Rp{{ number_format($obat->harga, 0, ',', '.') }}</td>
                <td class="p-2">{{ $obat->expired_at }}</td>
                <td class="p-2">{{ $obat->supplier_terakhir }}</td>
                <td class="p-2 flex gap-2">
                    <a href="{{ route('admin.obats.edit', $obat->id) }}" class="text-blue-600 hover:underline">Edit</a>
                    <form action="{{ route('admin.obats.destroy', $obat->id) }}" method="POST" onsubmit="return confirm('Yakin ingin hapus?')">
                        @csrf @method('DELETE')
                        <button class="text-red-600 hover:underline">Hapus</button>
                    </form>
                </td>
            </tr>
            @endforeach
        </tbody>
    </table>
</div>

{{-- Pagination --}}
<div class="mt-4">
    {{ $obats->links() }}
</div>
@endsection

@section('scripts')
{{-- jQuery & Select2 --}}
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

<script>
$(document).ready(function () {
    $('#obat-search').select2({
        placeholder: 'Ketik nama obat...',
        allowClear: true,
        minimumInputLength: 1,
        width: 'resolve',
        ajax: {
            url: '{{ route("ajax.obats.search") }}',
            dataType: 'json',
            delay: 250,
            data: function (params) {
                return { q: params.term };
            },
            processResults: function (data) {
                return {
                    results: data.map(function (item) {
                        return {
                            id: item.id,
                            text: item.nama
                        };
                    })
                };
            },
            cache: true
        }
    });

    $('#obat-search').on('select2:select', function (e) {
        const id = e.params.data.id;
        window.location.href = `?obat_id=${id}`;
    });
});
</script>
@endsection
