@extends('admin.layout')

@section('content')
<div class="max-w-4xl mx-auto bg-white rounded-xl shadow p-6">
    <div class="flex items-center gap-3 mb-6">
        <svg class="w-8 h-8 text-blue-600" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z" />
        </svg>
        <h2 class="text-2xl font-bold text-gray-800">Detail Master Obat</h2>
    </div>

    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
        <div class="bg-gray-50 p-4 rounded-lg">
            <h3 class="text-lg font-semibold text-gray-700 mb-3">Informasi Obat</h3>
            <div class="space-y-2">
                <div>
                    <label class="text-sm font-medium text-gray-600">Nama Obat:</label>
                    <p class="text-gray-800">{{ $obat->nama }}</p>
                </div>
                <div>
                    <label class="text-sm font-medium text-gray-600">Kategori:</label>
                    <p class="text-gray-800">{{ $obat->kategori->nama ?? 'Tidak ada kategori' }}</p>
                </div>
                <div>
                    <label class="text-sm font-medium text-gray-600">Status:</label>
                    <span class="px-2 py-1 text-xs rounded-full {{ $obat->status === 'aktif' ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800' }}">
                        {{ $obat->status }}
                    </span>
                </div>
                <div>
                    <label class="text-sm font-medium text-gray-600">Dibuat:</label>
                    <p class="text-gray-800">{{ $obat->created_at->format('d M Y H:i') }}</p>
                </div>
                <div>
                    <label class="text-sm font-medium text-gray-600">Terakhir Diupdate:</label>
                    <p class="text-gray-800">{{ $obat->updated_at->format('d M Y H:i') }}</p>
                </div>
            </div>
        </div>

        <div class="bg-gray-50 p-4 rounded-lg">
            <h3 class="text-lg font-semibold text-gray-700 mb-3">Riwayat Pembelian</h3>
            @if($obat->pembelianDetails->count() > 0)
                <div class="space-y-2 max-h-64 overflow-y-auto">
                    @foreach($obat->pembelianDetails as $detail)
                        <div class="bg-white p-3 rounded border">
                            <div class="flex justify-between items-start">
                                <div>
                                    <p class="text-sm font-medium">{{ $detail->pembelian->supplier->nama }}</p>
                                    <p class="text-xs text-gray-600">{{ $detail->pembelian->tanggal_pembelian->format('d M Y') }}</p>
                                </div>
                                <div class="text-right">
                                    <p class="text-sm font-medium">{{ $detail->jumlah }} {{ $detail->satuan }}</p>
                                    <p class="text-xs text-gray-600">Rp {{ number_format($detail->harga_beli, 0, ',', '.') }}</p>
                                </div>
                            </div>
                            @if($detail->expired_at)
                                <p class="text-xs text-red-600 mt-1">Kadaluarsa: {{ $detail->expired_at->format('d M Y') }}</p>
                            @endif
                        </div>
                    @endforeach
                </div>
            @else
                <p class="text-gray-500 text-sm">Belum ada riwayat pembelian</p>
            @endif
        </div>
    </div>

    <div class="flex justify-end gap-4 mt-6">
        <a href="{{ route('admin.master_obat.index') }}" class="bg-gray-500 hover:bg-gray-600 text-white px-4 py-2 rounded-lg">
            Kembali
        </a>
        <a href="{{ route('admin.master_obat.edit', $obat->id) }}" class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded-lg">
            Edit
        </a>
    </div>
</div>
@endsection
