@extends('admin.layout')

@section('content')
<div class="bg-white shadow rounded-xl p-6">
    <h1 class="text-2xl font-bold text-gray-800 mb-4">📦 Daftar Obat Kadaluarsa</h1>

    @if (session('success'))
        <div class="mb-4 p-3 bg-green-100 text-green-800 border border-green-300 rounded-lg">
            {{ session('success') }}
        </div>
    @endif

    @if ($masterObats->isEmpty())
        <div class="text-gray-500 text-center py-6">
            Tidak ada obat yang kadaluarsa saat ini.
        </div>
    @else
        <div class="overflow-x-auto">
            <table class="min-w-full border border-gray-200 rounded-lg">
                <thead class="bg-gray-100 text-gray-700 text-sm uppercase">
                    <tr>
                        <th class="px-4 py-2 text-left">Nama Obat</th>
                        <th class="px-4 py-2 text-left">Kategori</th>
                        <th class="px-4 py-2 text-left">Expired</th>
                        <th class="px-4 py-2 text-left">Total Stok</th>
                        <th class="px-4 py-2 text-center">Aksi</th>
                    </tr>
                </thead>
                <tbody class="text-sm text-gray-700 divide-y">
                    @foreach ($masterObats as $obat)
                    <tr class="hover:bg-gray-50">
                        <td class="px-4 py-2 font-medium">{{ $obat->nama }}</td>
                        <td class="px-4 py-2">{{ $obat->kategori->nama ?? '-' }}</td>
                        <td class="px-4 py-2 text-red-600 font-semibold">{{ \Carbon\Carbon::parse($obat->expired_at)->format('d M Y') }}</td>
                        <td class="px-4 py-2">{{ $obat->total_stok }} pcs</td>
                        <td class="px-4 py-2 text-center">
                            @if ($obat->status === 'aktif')
                                <form action="{{ route('admin.master_obat.nonaktifkan', $obat->id) }}" method="POST" class="inline-block">
                                    @csrf
                                    @method('PATCH')
                                    <button type="submit" class="bg-red-600 hover:bg-red-700 text-white text-xs px-3 py-1 rounded-lg transition">
                                        Nonaktifkan
                                    </button>
                                </form>
                            @else
                                <form action="{{ route('admin.master_obat.aktifkan', $obat->id) }}" method="POST" class="inline-block">
                                    @csrf
                                    @method('PATCH')
                                    <button type="submit" class="bg-green-600 hover:bg-green-700 text-white text-xs px-3 py-1 rounded-lg transition">
                                        Aktifkan
                                    </button>
                                </form>
                            @endif
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    @endif
</div>
@endsection
